<?php

namespace App\Http\Controllers\ChiefWorker;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Http\Requests\PasswordRequest;
use App\Models\Worker;
use App\Models\WorkReq;
use Morilog\Jalali\Jalalian;

class ProfileController extends Controller
{
    public function show()
    {
        return view('chiefWorker.profile');
    }

    public function password(PasswordRequest $request)
    {
        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'password' => $request->input('password')
        ]);

        return back()->with('success', 'رمز عبور تغییر کرد');
    }

    public function status()
    {

        $selecteduser = request()->input('user');
        $from = request()->input('from');
        $to = request()->input('to');

        $worker_sub = Worker::where('user_id', Auth::id())->first();
        $subusers = $worker_sub->sub_users;
        $user_workers = User::whereIn('id', $subusers)->get();

        if (!empty($selecteduser) && !empty($from) && !empty($to)) {
            $jDatefrom = Jalalian::fromFormat('Y/m/d', $from)->toCarbon();
            $jDateto = Jalalian::fromFormat('Y/m/d', $to)->toCarbon();

            $selecteduserrole = User::where('id', $selecteduser)->select('role')->first();

            $perPage = 25;
            $page = request()->input('page', 1);

            $UserRequests = WorkReq::where('user_requests.user_id', $selecteduser)
                ->where('user_requests.info->vaziat', 100)
                ->whereDate('user_requests.created_at', '>=', $jDatefrom)
                ->whereDate('user_requests.created_at', '<=', $jDateto)
                ->join('requests', 'requests.id', 'user_requests.request_id')
                ->join('users', 'users.id', 'requests.user_id')
                ->select('user_requests.info', 'user_requests.created_at as JobDate', 'requests.*', 'users.first_name', 'users.last_name')
                ->orderBy('requests.id', 'desc')
                ->paginate($perPage, ['*'], 'page', $page);


            $sumdata = [
                    'chief_price' => 0,
                    'worker_price' => 0
                ];

            
            foreach ($UserRequests as $key => $req) {
                if ($selecteduserrole->role == 'chief_worker') {
                    
                    if($req->info['vaziat'] == 100)
                    {
                        $sumdata['chief_price'] = $sumdata['chief_price'] + (int) $req->info['chiefprice'];
                        $sumdata['worker_price'] = $sumdata['worker_price'] + (int) $req->info['workerprice'];
                    }
                    
                } else if ($selecteduserrole->role == 'worker') {
                    if($req->info['vaziat'] == 100)
                    {
                        $sumdata['worker_price'] = $sumdata['worker_price'] + (int) $req->info['workerprice'];
                    }
                }
            }

            return view('chiefWorker.status', compact(['user_workers', 'UserRequests', 'selecteduserrole','sumdata']));
        }

        return view('chiefWorker.status', compact(['user_workers']));
    }
}
