<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ProfileRequest extends FormRequest
{
    public function authorize()
    {
        if (Auth::check() && Auth::user()->role == 'farmer') {
            return true;
        }

        return false;
    }


    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'farm_name' => 'required',
            'state' => 'required',
            'city' => 'required',
            'address' => 'required',
        ];
    }
}
