document.addEventListener("DOMContentLoaded", function () {
    const priceunit1 = document.getElementById("priceunit1");

    function addPriceSeparator(number) {
        number = removePriceSeparator(number);

        if(parseInt(number) >= 0)
        {
            return parseInt(number).toLocaleString();
        }
        return 0;
    }

    function removePriceSeparator(formattedNumber) {
        return formattedNumber.toString().replace(/,/g, "");
    }

    priceunit1.addEventListener('input', function() {
        let price = removePriceSeparator(document.getElementById("priceunit1").value);
        document.getElementById("priceunit").value = price;
        document.getElementById("priceunit1").value = addPriceSeparator(price);
    });
});