<div class="zar-table mt-3">
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نام کشاورز</th>
                <th>نام مزرعه</th>
                <th>نوع درخواست</th>
                <th>وزن گل</th>
                <th>وضعیت</th>
                <th>تاریخ ثبت</th>
                <th>عملیات</th>
            </tr>
        </thead>
        <tbody>
            @if ($UserRequests->isNotEmpty())
            @foreach ($UserRequests as $Info)
            @php
            if(!is_array($Info->step_info))
            {
                $Info->step_info = json_decode($Info->step_info, true);
            }
            @endphp

            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="نام کشاورز">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                <td data-label="نام مزرعه">{{ $Info->farm_name }}</td>
                <td data-label="نوع درخواست">
                    @switch($Info->type)
                    @case(1)
                    تحویل گل
                    @break
                    @case(2)
                    تحویل پیاز
                    @break
                    @endswitch
                </td>
                <td data-label="وزن گل">{{ $Info->weight['farmer'] }}</td>
                <td data-label="وضعیت">
                    @switch($Info->step)
                    @case(1)
                    درخواست جدید
                    @break
                    @case(2)
                    در انتظار تایید کشاورز
                    @break
                    @case(3)
                    قرارداد تایید شد
                    @break
                    @case(4)
                    در انتظار تحویل
                    @break
                    @case(5)
                    @if (strstr($Info->step_info[count($Info->step_info) - 1]['action'],'مغایرت'))
                    در انتظار تایید مرکز فراوری
                    @else
                    دریافت توسط راننده
                    @endif
                    @break
                    @case(6)
                    دریافت توسط مرکز فراوری
                    @break
                    @case(7)
                    توزیع به سرتیم ها
                    @break
                    @case(8)
                    اعلام اتمام کار توسط کارگران
                    @break
                    @case(9)
                    اتمام کار توسط همه سرتیم ها
                    @break
                    @case(10)
                    دریافت توسط مرکز خشک کن
                    @break
                    @case(11)
                    اتمام خشک کردن
                    @break
                    @case(12)
                    دریافت توسط واحد بسته بندی
                    @break
                    @case(13)
                    اتمام سفارش و ارسال
                    @break
                    @default
                    @if ($Info->step < 0 && $Info->step > -100)
                        مغایرت
                        @elseif ($Info->step < -100)
                            لغو شده
                            @endif
                            @endswitch
                            </td>
                <td data-label="تاریخ ثبت">{{ jdate($Info->created_at)->format('Y/m/d') }}</td>
                <td data-label="عملیات">
                    @if ($Info->step == 6)
                    <a href="{{route('distributor.view',['id' => $Info->id])}}" class="btn btn-primary">ثبت توزیع</a>
                    @else
                    عملیاتی نیاز نیست
                    @endif

                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="7" class="noinfotable">درخواستی یافت نشد</td>
            </tr>
            @endif

        </tbody>
    </table>
</div>
<div class="mt-3">
    {{ $UserRequests->links() }}
</div>