@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
@endsection
@section('js-part')
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">اطلاعات درخواست</h2>
    @include('layouts.notification.error')
    @include('chiefWorker.info.table')
    @include('chiefWorker.info.worker')

    @if ($myUserReq->info['vaziat'] == 1)

    <form action="{{route('chief.post.current.accept')}}" method="post" class="mt-3 mb-5">
        {{csrf_field()}}
        <input type="hidden" name="reqId" value="{{$RequestInfo->id}}">
        <div class="row">
            <div class="col-12 col-lg-4 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="colale" class="mb-2">وزن کلاله تر (گرم)</label>
                    <input type="number" step=0.01 name="colale" id="colale" class=" form-control">
                </div>

            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="root" class="mb-2">وزن ریشه (گرم)</label>
                    <input type="number" step=0.01 name="root" id="root" class=" form-control">
                </div>

            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="flower" class="mb-2">وزن گل (گرم)</label>
                    <input type="number" step=0.01 name="flower" id="flower" class=" form-control">
                </div>

            </div>
        </div>
        <div class="mt-3">
            <button type="submit" class="btn btn-success">ثبت و اتمام کار</button>
        </div>
    </form>

    @endif
</div>
@endsection