<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Http\Requests\PasswordRequest;
use App\Models\Settings;
use App\Models\Worker;
use App\Models\WorkReq;
use Morilog\Jalali\Jalalian;

class ProfileController extends Controller
{
    public function show()
    {
        return view('Admin.profile');
    }

    public function password(PasswordRequest $request)
    {
        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'password' => $request->input('password')
        ]);

        return back()->with('success', 'رمز عبور تغییر کرد');
    }

    public function profile(Request $request)
    {
        $first_name = $request->input('first_name');
        $last_name = $request->input('last_name');
        $melli_code = $request->input('melli_code');
        $phone = $request->input('phone');
        $username = $request->input('username');

        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'first_name' => $first_name,
            'last_name' => $last_name,
            'melli_code' => $melli_code,
            'phone' => $phone,
            'username' => $username
        ]);

        return back()->with('success', 'پروفایل ویرایش شد.');
    }

    public function setting()
    {
        $Settings = Settings::where('title','contract')->first();
        $contract = $Settings->value;

        $Settings = Settings::where('title','worker_salary')->first();
        $worker_salary = $Settings->value;

        $Settings = Settings::where('title','chiefworker_salary')->first();
        $chiefworker_salary = $Settings->value;

        $Settings = Settings::where('title','dryer_salary')->first();
        $dryer_salary = $Settings->value;

        return view('Admin.setting',compact(['contract','worker_salary','chiefworker_salary', 'dryer_salary']));
    }

    public function contract(Request $request)
    {
        $contract = $request->input('contract');

        $Settings = Settings::where('title','contract')->first();
        $Settings->value = $contract;
        $Settings->save();

        return redirect()->back()->with('success','متن قرارداد ثبت شد');
    }

    public function salary(Request $request)
    {
        $worker_salary = $request->input('workerPrice');
        $chiefworker_salary = $request->input('chiefWorkerPrice');
        $dryer_salary = $request->input('dryerPrice');

        if(ctype_digit($worker_salary) && ctype_digit($chiefworker_salary) && ctype_digit($dryer_salary) && $dryer_salary > 0 && $worker_salary > 0 && $chiefworker_salary > 0)
        {
            $Settings = Settings::where('title','worker_salary')->first();
            $Settings->value = $worker_salary;
            $Settings->save();

            $Settings = Settings::where('title','chiefworker_salary')->first();
            $Settings->value = $chiefworker_salary;
            $Settings->save();

            $Settings = Settings::where('title','dryer_salary')->first();
            $Settings->value = $dryer_salary;
            $Settings->save();
        }

        return redirect()->back()->with('success','مبالغ دستمزد ثبت شد.');
    }
}
