<?php

namespace App\Http\Controllers\Worker;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use App\Models\User;
use App\Models\Worker;
use App\Models\WorkReq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\Jalalian;

class UserController extends Controller
{
    
    public function show()
    {
        $perPage = 25;
        $page = request()->input('page', 1);

        $UserRequests = WorkReq::where('user_requests.user_id', Auth::id())
            ->join('requests', 'requests.id', 'user_requests.request_id')
            ->join('users', 'users.id', 'requests.user_id')
            ->where('user_requests.info->vaziat', 1)
            ->where('requests.step', '>=', 7)
            ->where('requests.step', '<', 9)
            ->select('requests.*', 'users.first_name', 'users.last_name', 'user_requests.info', 'user_requests.id as urid')
            ->orderBy('requests.id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('worker.index', compact('UserRequests'));
    }

    public function viewEdit($id = null)
    {
        if ($id != null && (int) $id > 0) {
            $RequestInfo = WorkReq::where('user_requests.id', $id)
                ->join('requests', 'requests.id', '=', 'user_requests.request_id')
                ->join('users', 'requests.user_id', '=', 'users.id')
                ->select('requests.*', 'users.first_name', 'users.last_name', 'user_requests.info', 'user_requests.id as urid')
                ->first();

            $myUserReq = WorkReq::where('user_id', Auth::id())->where('request_id', $RequestInfo->id)->first();

            return view('worker.edit', compact(['RequestInfo', 'myUserReq']));
        }

        return redirect()->route('worker.panel');
    }

    public function accept(Request $request)
    {
        $RequestInfo = AppRequest::where('id', $request->requestId)->first();

        $myUserReq = WorkReq::where('user_id', Auth::id())->where('request_id', $request->requestId)->first();

        $allUserReq = WorkReq::where('user_requests.request_id', $request->requestId)
            ->whereNotNull('user_requests.info')
            ->join('users', 'users.id', 'user_requests.user_id')
            ->where('users.role', 'chief_worker')
            ->select('user_requests.*')
            ->get();

        $chiefWorkerIds = $allUserReq->pluck('user_id')->toArray();
        $stepUserIds = [];
        foreach ($RequestInfo->step_info as $step_info) {
            if ($step_info['action'] == 'به کارگران تخصیص یافت') {
                if (isset($step_info['user_id'])) {
                    $stepUserIds[] = $step_info['user_id'];

                    $allChiefWorkersInStep = empty(array_diff($chiefWorkerIds, $stepUserIds));

                    if ($allChiefWorkersInStep && !empty($chiefWorkerIds)) {
                        $RequestInfo->step = 8;
                    }
                }
            }
        }
        
        $urinfo = $myUserReq->info;
        
        $urinfo['action'] = 'کار را به اتمام رساند';
        $urinfo['vaziat'] = 2;
        $myUserReq->info = $urinfo;
        $myUserReq->save();

        //$RequestInfo->step = 8;

        $stepInfo = $RequestInfo->step_info;

        if (!is_array($stepInfo)) {
            $stepInfo = [];
        }

        $stepInfo[] = [
            'action' => 'کارگر '.Auth::user()->first_name.' '.Auth::user()->last_name.' کار خود را تمام کرد.',
            'user_id' => Auth::id(),
            'date' => Jalalian::now()->format('Y/m/d H:i:s')
        ];

        $RequestInfo->step_info =  $stepInfo;

        $RequestInfo->save();

        return redirect()->route('worker.panel');
    }

    public function current()
    {
        $perPage = 25;
        $page = request()->input('page', 1);

        $UserRequests = WorkReq::where('user_requests.user_id', Auth::id())
            ->join('requests', 'requests.id', 'user_requests.request_id')
            ->join('users', 'users.id', 'requests.user_id')
            ->whereIn('user_requests.info->vaziat', [2,100])
            ->select('requests.*', 'users.first_name', 'users.last_name', 'user_requests.info', 'user_requests.id as urid')
            ->orderBy('requests.id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('worker.index', compact('UserRequests'));
    }

}
