<div class="mt-3">


    <strong class="mt-3 mb-3">لیست کار کنان</strong>
    <div class="zar-table">
        <table>
            <thead>
                <tr>
                    <th>ردیف</th>
                    <th>نام کاربر</th>
                    <th>کد کاربر</th>
                    <th>شماره موبایل</th>
                    <th>نقش</th>
                    <th>وزن</th>
                    <th>دستمزد</th>
                </tr>
            </thead>
            <tbody>
                @if ($AllselectedUsers->isNotEmpty())
                @foreach ($AllselectedUsers as $Info)
                <tr>
                    <td data-label="ردیف">{{ $loop->iteration }}</td>
                    <td data-label="نام کاربر">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                    <td data-label="کد کاربر">{{ $Info->id }}</td>
                    <td data-label="شماره موبایل">{{ $Info->phone }}</td>
                    <td data-label="نقش">
                        @switch($Info->role)
                        @case('transporter')
                        راننده
                        @break
                        @case('factory_receiver')
                        مرکز فراوری
                        @break
                        @case('contractor')
                        امور قرارداد
                        @break
                        @case('chief_worker')
                        سرتیم
                        @break
                        @case('worker')
                        کارگر
                        @break
                        @case('dryer')
                        خشک کن
                        @break
                        @case('packager')
                        بسته بندی
                        @break
                        @case('distributor')
                        توزیع کننده 
                        @break

                        @endswitch
                    </td>
                    <td data-label="وزن">
                        @if (isset($weight_data[$Info->id]))
                        {{$weight_data[$Info->id]}}
                        @else
                        -
                        @endif
                    </td>
                    <td data-label="دستمزد">
                        @if (isset($price_data[$Info->id]))
                        {{number_format($price_data[$Info->id])}} تومان
                        @else
                        -
                        @endif
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="7" class="noinfotable">کاربری یافت نشد</td>
                </tr>
                @endif

            </tbody>
        </table>
    </div>
</div>