<div class="zar-table mt-3">
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نام و نام خانوادگی</th>
                <th>کد کاربر</th>
                <th>نقش</th>
                <th>شماره موبایل</th>
                <th>کد ملی</th>
                <th>عملیات</th>
            </tr>
        </thead>
        <tbody>
            @if ($UserInfo->isNotEmpty())
            @foreach ($UserInfo as $Info)
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="نام و نام خانوادگی">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                <td data-label="کد کاربر">{{ $Info->id }}</td>
                <td data-label="نقش">
                    @switch($Info->role)
                        @case('transporter')
                            راننده
                        @break
                        @case('factory_receiver')
                            مرکز فراوری
                        @break
                        @case('contractor')
                            امور قرارداد
                        @break
                        @case('chief_worker')
                            سرتیم
                        @break
                        @case('worker')
                            کارگر
                        @break
                        @case('dryer')
                            خشک کن
                        @break
                        @case('packager')
                            بسته بندی
                        @break
                        @case('distributor')
                        توزیع کننده 
                        @break
                            
                    @endswitch
                </td>
                <td data-label="شماره موبایل">{{ $Info->phone }}</td>
                <td data-label="کد ملی">{{ $Info->melli_code }}</td>
                <td data-label="عملیات">
                    <a href="{{route('admin.user.view',['id' => $Info->id])}}" class="btn btn-primary">جزئیات</a>
                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="7" class="noinfotable">کاربری یافت نشد</td>
            </tr>
            @endif

        </tbody>
    </table>
</div>
<div class="mt-3">
    {{ $UserInfo->appends(request()->query())->links() }}
</div>