<?php

namespace App\Http\Controllers\ChiefWorker;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Http\Requests\PasswordRequest;
use App\Models\AppRequest;
use App\Models\Worker;
use App\Models\WorkReq;
use Morilog\Jalali\Jalalian;

class ProfileController extends Controller
{
    public function show()
    {
        return view('chiefWorker.profile');
    }

    public function password(PasswordRequest $request)
    {
        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'password' => $request->input('password')
        ]);

        return back()->with('success', 'رمز عبور تغییر کرد');
    }

    public function status()
    {

        $selecteduser = request()->input('user');
        $from = request()->input('from');
        $to = request()->input('to');
        $action = request('action');

        $worker_sub = Worker::where('user_id', Auth::id())->first();
        $subusers = $worker_sub->sub_users;
        $user_workers = User::whereIn('id', $subusers)->get();

        if (!empty($selecteduser)) {

            $selecteduserrole = User::where('id', $selecteduser)->first();

            $perPage = 25;
            $page = request()->input('page', 1);

            $query = WorkReq::where('user_requests.user_id', $selecteduser)
                ->where('user_requests.info->vaziat', '!=', 1)
                ->join('requests', 'requests.id', 'user_requests.request_id')
                ->join('users', 'users.id', 'requests.user_id');

            if ($from) {
                $jDatefrom = Jalalian::fromFormat('Y/m/d', $from)->toCarbon();
                $query->whereDate('user_requests.created_at', '>=', $jDatefrom);
            }

            if ($from) {
                $jDateto = Jalalian::fromFormat('Y/m/d', $to)->toCarbon();
                $query->whereDate('user_requests.created_at', '<=', $jDateto);
            }

            $query->select('user_requests.info', 'user_requests.created_at as JobDate', 'requests.*', 'users.first_name', 'users.last_name');

            $AllUserRequests = $query->get();

            if($action == 'show')
            {
                $UserRequests = $query->orderBy('requests.id', 'desc')
                ->paginate($perPage, ['*'], 'page', $page);
            }
            else 
            {
                $UserRequests =  $AllUserRequests;
            }
            


            $sumdata = [
                'name' => $selecteduserrole->first_name.' '.$selecteduserrole->last_name,
                'melli_code' => $selecteduserrole->melli_code,
                'chief_price' => 0,
                'worker_price' => 0,
                'weight' => 0
            ];


            foreach ($AllUserRequests as $key => $req) {
                if ($selecteduserrole->role == 'chief_worker') {

                    if ($req->info['vaziat'] != 1) {
                        $sumdata['chief_price'] = $sumdata['chief_price'] + ((int) $req->info['chiefprice'] * (float) $req->info['weight']);
                        //$sumdata['worker_price'] = $sumdata['worker_price'] + ((int) $req->info['workerprice'] * (float) $req->info['weight']);
                        $sumdata['weight'] = $sumdata['weight'] + (float) $req->info['weight'];
                    }
                } else if ($selecteduserrole->role == 'worker') {
                    if ($req->info['vaziat'] != 1) {
                        $sumdata['worker_price'] = $sumdata['worker_price'] + ((int) $req->info['workerprice'] * (float) $req->info['weight']);
                        $sumdata['weight'] = $sumdata['weight'] + (float) $req->info['weight'];
                    }
                }
            }

            return view('chiefWorker.status', compact(['user_workers', 'UserRequests', 'selecteduserrole', 'sumdata']));
        }

        return view('chiefWorker.status', compact(['user_workers']));
    }

}
