<?php

namespace App\Http\Controllers\ChiefWorker;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Requests\CWUserAddRequest;
use App\Models\Worker;
use Illuminate\Support\Facades\Auth;

class WorkerController extends Controller
{
    // بخش مدیریت کاربران
    public function show()
    {

        $worker_sub = Worker::where('user_id',Auth::id())->first();
        $subusers = $worker_sub->sub_users;
        
        $user_worker = User::whereIn('id', $subusers)->get();

        if (request('filter_user')) {
            
            $user_selected = User::where('users.id', request('filter_user'))
                            ->where('users.role', 'worker')
                            ->first();

            return view('chiefWorker.user', compact(['user_worker', 'user_selected']));
        }
        
        return view('chiefWorker.user',compact(['user_worker']));
    }

    
    public function add(CWUserAddRequest $request)
    {
        $user_input = [
            'first_name' => $request->input('first_name'),
            'last_name' => $request->input('last_name'),
            'melli_code' => $request->input('melli_code'),
            'phone' => $request->input('phone'),
            'username' => $request->input('melli_code'),
            'password' => $request->input('phone'),
            'role' => 'worker',
        ];

        $returned_user = User::create($user_input);

        if ($returned_user !== null) {

            $worker_sub = Worker::where('user_id',Auth::id())->first();

            if ($worker_sub !== null) {

            $subusers = $worker_sub->sub_users;
            $subusers[] = $returned_user->id;
            $worker_sub->sub_users = $subusers;
            $worker_sub->save();
            }
            else
            {
                $worker_sub = new Worker();
                $worker_sub->user_id = Auth::id();
                $worker_sub->sub_users = [$returned_user->id];
                $worker_sub->save();
            }

            return redirect()->back()->with('success', 'کاربر جدید اضافه شد.');
        }

        return redirect()->back()->with('error', 'مشکلی در افزودن کاربر رخ داد.');
    }

    public function delete(Request $request)
    {
        if(Auth::check() && Auth::user()->role == 'chief_worker')
        {
            $selected_user = User::find($request->input('userId'));

            if($selected_user !== null)
            {
                $selected_user->delete();

                $worker_sub = Worker::where('user_id',Auth::id())->first();
                $subusers = $worker_sub->sub_users;
                unset($subusers[$request->input('userId')]);
                $worker_sub->sub_users = $subusers;
                $worker_sub->save();

                return redirect()->back()->with('success', 'کاربر حذف شد.');
            }
            
        }

        return redirect()->back()->with('error', 'مشکلی در حذف کاربر رخ داد.');
    }

    public function edit(Request $request)
    {
        $userid = $request->input('userid');

        if ($userid !== null && (int) $userid > 0) {
            $UserInfo = User::where('id', $userid)->first();
            $UserInfo->first_name = $request->input('first_name');
            $UserInfo->last_name = $request->input('last_name');
            $UserInfo->save();

            return redirect()->back()->with('success', 'کاربر ویرایش شد.');
        }

        return redirect()->back()->with('error', 'مشکلی در ویرایش رخ داد.');
    }
}
