<?php

class IppanelSMS {
    private $base_url = "https://edge.ippanel.com/v1";
    private $token;
    
    public function __construct($token) {
        $this->token = $token;
    }
    
    /**
     * ارسال پیامک با استفاده از الگو (pattern)
     */
    public function sendPattern($from_number, $pattern_code, $recipients, $params = []) {
        $url = $this->base_url . "/api/send";
        
        // آماده کردن داده‌ها
        $data = [
            'sending_type' => 'pattern',
            'from_number' => $from_number,
            'code' => $pattern_code,
            'recipients' => $recipients,
            'params' => $params
        ];
        
        // تبدیل به JSON
        $payload = json_encode($data);
        
        // تنظیمات درخواست
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: ' . $this->token,
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload)
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // غیرفعال کردن بررسی SSL (در صورت نیاز)
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        // اجرای درخواست
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        
        curl_close($ch);
        
        // پردازش پاسخ
        if ($response === false) {
            return [
                'success' => false,
                'error' => 'CURL Error: ' . $error
            ];
        }
        
        $result = json_decode($response, true);
        
        return [
            'success' => $http_code == 200,
            'http_code' => $http_code,
            'response' => $result,
            'error' => $error
        ];
    }
}

$token = "OWZjYTgxOTktMDIyMS00NWRjLWJmOWMtMTk2Njk5MTI5ZmJlOTA4YWFhMGI2ZmI5YmJmZTI2ZjAxMWQzMWY5YWYwNjE=";

$sms = new IppanelSMS($token);

$from_number = "+983000505";


$pattern_code = "nkijq9sdcwqwc02";


$recipients = [
    "09033591161"
];

$params = [
    "code" => "متن جایگذاری",
];

$phonebook_data = [
    
];

$result = $sms->sendPattern($from_number, $pattern_code, $recipients, $params);

if ($result['success']) {
    echo "پیامک با موفقیت ارسال شد!";
    echo "\nResponse: " . json_encode($result['response'], JSON_UNESCAPED_UNICODE);
} else {
    echo "خطا در ارسال پیامک: ";
    echo "\nHTTP Code: " . $result['http_code'];
    echo "\nError: " . $result['error'];
    echo "\nResponse: " . json_encode($result['response'], JSON_UNESCAPED_UNICODE);
}

// نمونه ساده‌تر بدون phonebook:
/*
$result = $sms->sendPattern(
    $from_number, 
    $pattern_code, 
    $recipients, 
    $params
);
*/
?>