<div class="mt-3">
    <strong class="mb-2">اطلاعات وضعیت ها:</strong>
    <table class="step-table">
        <tr>
            <th class="notprint">#</th>
            <th>کد کاربر</th>
            <th>گزارش</th>
            <td>تاریخ</td>
        </tr>
        @if (is_array($RequestInfo->step_info))
        @foreach ($RequestInfo->step_info as $key => $step_info)
        <tr id="step{{$key}}">
            <td class="notprint"><i class="fa-solid fa-circle-minus" style="color: #ff0000; cursor: pointer;" data-id="step{{$key}}"></i></td>
            <th>
                @if (isset($step_info['user_id']))
                {{$step_info['user_id']}}
                @else
                -
                @endif

            </th>
            <th>{{$step_info['action']}}</th>
            <td>{{$step_info['date']}}</td>
        </tr>
        @endforeach
        @endif
    </table>
</div>

@if ($RequestInfo->step > 0)


<div class="mt-3 notprint">
    <strong class="mb-2">تغییر وضعیت:</strong>
    <form action="{{route('admin.post.step.change')}}" method="post">
        {{csrf_field()}}
        <input type="hidden" name="requestId" value="{{$RequestInfo->id}}">
        <div class="d-flex justify-content-between">
            <div class="form-group">
                <select name="step" id="step" class="form-control">
                    <option value="1" {{$RequestInfo->step == 1 ? 'selected' : ''}}>1. درخواست جدید</option>
                    <option value="2" {{$RequestInfo->step == 2 ? 'selected' : ''}}>2. در انتظار تایید قرارداد</option>
                    <option value="3" {{$RequestInfo->step == 3 ? 'selected' : ''}}>3. تایید قرارداد</option>
                    <option value="4" {{$RequestInfo->step == 4 ? 'selected' : ''}}>4. در انتظار تحویل</option>
                    <option value="5" {{$RequestInfo->step == 5 ? 'selected' : ''}}>5. تایید تحویل راننده</option>
                    <option value="6" {{$RequestInfo->step == 6 ? 'selected' : ''}}>6. تایید دریافت مرکز فراوری</option>
                    <option value="7" {{$RequestInfo->step == 7 ? 'selected' : ''}}>7. تایید دریافت گل توسط سرتیم</option>
                    <option value="8" {{$RequestInfo->step == 8 ? 'selected' : ''}}>8. تایید اتمام توسط کارگر</option>
                    <option value="9" {{$RequestInfo->step == 9 ? 'selected' : ''}}>9. تایید توسط سرتیم و ارسال به واحد خشک کن</option>
                    <option value="10" {{$RequestInfo->step == 10 ? 'selected' : ''}}>10. دریافت توسط خشک کن</option>
                    <option value="11" {{$RequestInfo->step == 11 ? 'selected' : ''}}>11. اتمام خشک کردن</option>
                    <option value="12" {{$RequestInfo->step == 12 ? 'selected' : ''}}>12. تایید دریافت توسط واحد بسته بندی</option>
                    <option value="13" {{$RequestInfo->step == 13 ? 'selected' : ''}}>13. اتمام بسته بندی</option>
                </select>
            </div>
            <div class="form-group">
                <button type="submit" class="btn btn-outline-dark">تغییر وضعیت</button>
            </div>
        </div>

    </form>
</div>
@endif
<div class="mt-3">
    <strong class="mb-2">اطلاعات قرارداد:</strong>
    <table class="step-table">
        @if (is_array($RequestInfo->contract) && $RequestInfo->contract['isAccepted'])
        <tr>
            <th>توسط کشاورز تایید شد</th>
            <td>{{$RequestInfo->contract['acceptedDate']}}</td>
        </tr>
        @endif
        @if (is_array($RequestInfo->contract) && isset($RequestInfo->contract['priceperunit']))
        <tr>
            <th>قیمت واحد</th>
            @if (strstr($RequestInfo->contract['priceperunit'],",") || strstr($RequestInfo->contract['priceperunit'],"٬"))
            <td>{{$RequestInfo->contract['priceperunit']}}</td>
            @else
            <td>{{number_format((int) $RequestInfo->contract['priceperunit'])}}</td>
            @endif
        </tr>
        @endif
        @if (is_array($RequestInfo->contract) && isset($RequestInfo->contract['pricetotal']))
        <tr>
            <th>قیمت کل</th>
            <td>{{number_format($RequestInfo->contract['pricetotal'])}} تومان</td>
        </tr>
        @endif
        @if (is_array($RequestInfo->transportation) && isset($RequestInfo->transportation['price']))
        <tr>
            <th>هزینه حمل و نقل</th>
            <td>{{number_format($RequestInfo->transportation['pricetotal'])}} تومان</td>
        </tr>
        @endif
        @if (is_array($RequestInfo->contract) && isset($RequestInfo->contract['dryerprice']))
        <tr>
            <th>هزینه واحد خشک کن</th>
            <td>{{number_format($RequestInfo->contract['dryerpriceunit'] * $RequestInfo->weight['dryer']['کلاله'])}} تومان</td>
        </tr>
        @endif
    </table>
</div>

<div class="mt-3">
    <strong class="mb-2">اطلاعات وزن ها:</strong>
    <table class="step-table">
        @if (isset($weightInfo['farmer']))
        <tr>
            <th>کشاورز</th>
            <td>{{$weightInfo['farmer']}}</td>
        </tr>
        @endif
        @if (isset($weightInfo['transporter']))
        <tr>
            <th>راننده</th>
            <td>{{$weightInfo['transporter']}}</td>
        </tr>
        @endif
        @if (isset($weightInfo['chief']))
        @foreach ($weightInfo['chief'] as $weight)
        <tr>
            <th>سرتیم: {{$weight['name']}}</th>
            <td>کلاله تر {{$weight['کلاله']}} گرم - ریشه {{$weight['ریشه']}}گرم - گل {{$weight['گل']}} گرم</td>
        </tr>
        @endforeach
        @endif
        @if (isset($weightInfo['dryer']))
        @if (isset($weightInfo['dryer']['کلاله']))
        <tr>
            <th>واحد خشک کن</th>
            <td>کلاله تر {{$weightInfo['dryer']['کلاله']}} گرم</td>
        </tr>
        @endif
        @if (isset($weightInfo['dryer']['زعفران']))
        <tr>
            <th>واحد خشک کن</th>
            <td>کلاله خشک {{$weightInfo['dryer']['زعفران']}} گرم</td>
        </tr>
        @endif
        @endif
    </table>
</div>

<div class="mt-3">
    <strong class="mb-2"> کارگران سرتیم ها:</strong>
    <table class="step-table">
        @foreach ($userSubs as $userSub)
        <tr>
            <th>{{$userSub->first_name}} {{$userSub->last_name}}</th>
            <td>{{implode(", ",$userSub->sub_users)}}</td>
        </tr>
        @endforeach
    </table>
</div>

<div class="zar-table mt-3">
    <strong class="mb-2">اطلاعات کارکنان:</strong>
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نقش</th>
                <th>کد کارمند</th>
                <th>نام کارمند</th>
                <th>شماره تماس</th>
                <th>کد ملی</th>
                <th>وزن</th>
                <th>توزیع کننده</th>
                <th>قیمت</th>
                <th class="notprint">عملیات</th>
            </tr>
        </thead>
        <tbody>
            @if ($UserRequests->isNotEmpty())
            @foreach ($UserRequests as $Info)
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="نقش">
                    @switch($Info->role)
                    @case('transporter')
                    راننده
                    @break
                    @case('chief_worker')
                    سرتیم
                    @break
                    @case('worker')
                    کارگر
                    @break
                    @endswitch
                </td>
                <td data-label="کد کارمند">{{ $Info->id }}</td>
                <td data-label="نام کارمند">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                <td data-label="شماره تماس">{{ $Info->phone }}</td>
                <td data-label="کد ملی">{{ $Info->melli_code }}</td>
                <td data-label="وزن">
                    @if ($Info->info != null)
                    {{$Info->info['weight']}}
                    @else
                    -
                    @endif
                </td>
                <td data-label="توزیع کننده">
                    @if ($Info->info != null && isset($Info->info['distributor_name']))
                    {{$Info->info['distributor_name']}}
                    @else
                    -
                    @endif
                </td>
                <td data-label="قیمت">
                    @if ($Info->info != null)
                    @if (isset($Info->info['chiefprice']))
                    || سرتیم: {{number_format($Info->info['chiefprice'])}} تومان ||
                    @endif
                    @if (isset($Info->info['workerprice']))
                    || کارگر: {{number_format($Info->info['workerprice'])}} تومان ||
                    @endif
                    @else
                    -
                    @endif
                </td>
                <td data-label="عملیات" class="notprint">
                    @if ($Info->role == 'chief_worker')
                    <form action="{{route('admin.post.remove')}}" method="post">
                        {{csrf_field()}}
                        <input type="hidden" name="requestId" value="{{$RequestInfo->id}}">
                        <input type="hidden" name="userId" value="{{$Info->id}}">
                        <button type="submit" class="btn btn-outline-danger">حذف کاربر</button>
                    </form>
                    @else
                    -
                    @endif
                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="8" class="noinfotable">کارمندی یافت نشد</td>
            </tr>
            @endif

        </tbody>
    </table>
</div>

<div class="mt-3">
    <label for="" class="mb-2">متن قرارداد</label>
    @if ($RequestInfo->contract != null && is_array($RequestInfo->contract))
    @include('layouts.editor.editor',['text' => $RequestInfo->contract['text']])
    @endif
</div>

<div class="justify-content-between mt-3 cancelpart" style="display: flex;">
    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#cancelModal">لغو درخواست</button>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#noteModal">ثبت یادداشت</button>
</div>

<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">لغو درخواست</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که لغو شود؟</p>
                <p class="text-danger text-center">در صورت لغو امکان فعالسازی مجدد وجود ندارد</p>
                @if ($RequestInfo->step > -100)
                <form action="{{route('admin.post.cancel')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="CancelId" value="{{$RequestInfo->id}}">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">لغو درخواست</button>
                    </div>
                </form>
                @else
                <form action="{{route('admin.post.delete')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="deleteId" value="{{$RequestInfo->id}}">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">حذف درخواست</button>
                    </div>
                </form>
                @endif


            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="noteModal" tabindex="-1" aria-labelledby="noteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="noteModalLabel">ثبت یادداشت</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('admin.post.add.note')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="requestId" value="{{$RequestInfo->id}}">
                    <textarea name="note" id="note" rows="10" class=" form-control mb-3"></textarea>
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-outline-primary">ثبت یادداشت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>