<div class="mt-3">
    <strong class=" mt-3 mb-3">لیست سفارشات</strong>
    <div class="zar-table">
        <table>
            <thead>
                <tr>
                    <th>ردیف</th>
                    <th>نام کشاورز</th>
                    <th>نام مزرعه</th>
                    <th>کد سفارش</th>
                    <th>وزن گل</th>
                    <th>نوع درخواست</th>
                    <th>وضعیت</th>
                    <th>تاریخ ثبت</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
                @if ($RequestInfo->isNotEmpty())
                @foreach ($RequestInfo as $Info)
                @php
                    if(!is_array($Info->weight))
                    {
                        $Info->weight = json_decode($Info->weight, true);
                    }
                @endphp
                <tr>
                    @if (strstr(json_encode($Info->step_info, JSON_UNESCAPED_UNICODE),'یادداشت توسط'))
                        <td data-label="ردیف" style="color: red; font-weight: 700;">{{ $loop->iteration + ((int) request('page') * 25) }}</td>
                    @else
                        <td data-label="ردیف">{{ $loop->iteration + ((int) request('page') * 25) }}</td>
                    @endif
                    
                    <td data-label="نام کشاورز">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                    <td data-label="نام مزرعه">{{ $Info->farm_name }}</td>
                    <td data-label="کد سفارش">{{ $Info->id }}</td>
                    <td data-label="وزن گل">{{ $Info->weight['farmer'] }}</td>
                    <td data-label="نوع درخواست">
                        @switch($Info->type)
                        @case(1)
                        تحویل گل
                        @break
                        @case(2)
                        تحویل پیاز
                        @break
                        @endswitch
                    </td>
                    <td data-label="وضعیت">
                        @switch($Info->step)
                        @case(1)
                        درخواست جدید
                        @break
                        @case(2)
                        در انتظار تایید کشاورز
                        @break
                        @case(3)
                        قرارداد تایید شد
                        @break
                        @case(4)
                        در انتظار تحویل
                        @break
                        @case(5)
                        @if (strstr($Info->step_info[count($Info->step_info) - 1]['action'],'مغایرت'))
                        در انتظار تایید مرکز فراوری
                        @else
                        دریافت توسط راننده
                        @endif
                        @break
                        @case(6)
                        دریافت توسط مرکز فراوری
                        @break
                        @case(7)
                        توزیع به سرتیم ها
                        @break
                        @case(8)
                        اعلام اتمام کار توسط کارگران
                        @break
                        @case(9)
                        اتمام کار توسط همه سرتیم ها
                        @break
                        @case(10)
                        دریافت توسط مرکز خشک کن
                        @break
                        @case(11)
                        اتمام خشک کردن
                        @break
                        @case(12)
                        دریافت توسط واحد بسته بندی
                        @break
                        @case(13)
                        اتمام سفارش و ارسال
                        @break
                        @default
                        @if ($Info->step < 0 && $Info->step > -100)
                            مغایرت
                            @elseif ($Info->step < -100)
                                لغو شده
                                @endif
                                @endswitch
                                </td>
                    <td data-label="تاریخ ثبت">{!! jdate($Info->created_at)->format('Y/m/d') !!}</td>
                    <td data-label="عملیات">
                        <a href="{{route('admin.view',['id' => $Info->id])}}" class="btn btn-primary">جزئیات</a>
                    </td>
                </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="7" class="noinfotable">درخواستی یافت نشد</td>
                </tr>
                @endif

            </tbody>
        </table>
    </div>
    <div class="mt-3">
        {{ $RequestInfo->appends(request()->query())->links() }}
    </div>
</div>