@extends('layouts.index')
@section('css-part')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-5-theme/1.3.0/select2-bootstrap-5-theme.min.css" />
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
@endsection
@section('js-part')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script>
    $(document).ready(function() {
        $("#user").select2({
            theme: "bootstrap-5",
            placeholder: "انتخاب کاربر",
            allowClear: false,
            language: "fa",
            width: "100%",
        });
    });

    $(document).ready(function() {
        $("#userFilter").select2({
            theme: "bootstrap-5",
            placeholder: "انتخاب کاربر",
            allowClear: false,
            language: "fa",
            width: "100%",
        });
    });
</script>

@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">ارسال پیام به کاربران</h2>
    @include('layouts.notification.success')
    @include('layouts.notification.error')

    <form action="{{route('admin.post.add.notif')}}" method="post" style="border-bottom: 1px solid black; padding-bottom: 10px;">
        {{csrf_field()}}
        <div class="d-flex justify-content-between">
            <div class="col-5 form-group">
                <label for="user" class="mb-2">انتخاب کاربر</label>
                <select name="user" id="user" class=" form-control">
                    <option value="0">انتخاب کاربر</option>
                    @foreach ($AllUsers as $UserInfo)
                    <option value="{{$UserInfo->id}}">{{$UserInfo->first_name}} {{$UserInfo->last_name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-5 form-group">
                <label for="role" class="mb-2">نقش کاربر</label>
                <select name="role" id="role" class=" form-control">
                    <option value="0">نقش کاربر</option>
                    <option value="chief_worker">سرتیم</option>
                    <option value="farmer">کشاورز</option>
                    <option value="transporter">راننده</option>
                    <option value="contractor">امور قرارداد</option>
                    <option value="worker">کارگر</option>
                    <option value="dryer">خشک کن</option>
                    <option value="packager">بسته بندی</option>
                </select>
            </div>
        </div>
        <div class="form-group mt-3">
            <label for="message" class="mb-2">متن پیام</label>
            <textarea name="message" id="message" rows="10" class="form-control"></textarea>
        </div>
        <div class="mt-3">
            <button type="submit" class="btn btn-success">ثبت پیام</button>
        </div>
    </form>

    <form action="" method="get" class="mt-3">
        <div class="row">
            <div class="col-12 col-md-6 mt-3">
                <select name="user" id="userFilter" class=" form-control">
                    <option value="0">انتخاب کاربر</option>
                    @foreach ($AllUsers as $UserInfo)
                    <option value="{{$UserInfo->id}}">{{$UserInfo->first_name}} {{$UserInfo->last_name}}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-md-6 mt-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary">فیلتر</button>
            </div>
            @if(request('user') )
            <div class="col-12 col-md-4 mt-3 d-flex align-items-end">
                <a href="{{ request()->url() }}" class="btn btn-outline-secondary">حذف فیلتر</a>
            </div>
            @endif
        </div>
    </form>
    @include('Admin.list.message')


</div>
@endsection