<div class="mt-3">
    <strong class="mb-2"> مجموع درآمدها:</strong>
    <table class="step-table">
        <tr>
            <th>نام و نام خانوادگی</th>
            <td>{{$sumdata['name']}}</td>
        </tr>
        <tr>
            <th>کد ملی</th>
            <td>{{$sumdata['melli_code']}}</td>
        </tr>
        @if ($selecteduserrole->role == 'chief_worker')
        <tr>
            <th>مجموع دستمزد سرتیم</th>
            <td>{{$sumdata['chief_price']}} تومان</td>
        </tr>
        @elseif ($selecteduserrole->role == 'worker')
        <tr>
            <th>مجموع دستمزد کارگر</th>
            <td>{{$sumdata['worker_price']}} تومان</td>
        </tr>
        @endif
        <tr>
            <th>مجموع وزن</th>
            <td>{{$sumdata['weight']}} کیلوگرم</td>
        </tr>
    </table>
</div>

<div class="zar-table mt-3">
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نوع درخواست</th>
                <th>وزن</th>
                @if ($selecteduserrole->role == 'chief_worker')
                <th>دستمزد سرتیم</th>
                @endif
                <th>دستمزد کارگر</th>
                <th>تاریخ</th>
            </tr>
        </thead>
        <tbody>
            @if ($UserRequests->isNotEmpty())
            @foreach ($UserRequests as $Info)
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="نوع درخواست">
                    @switch($Info->type)
                    @case(1)
                    تحویل گل
                    @break
                    @case(2)
                    تحویل پیاز
                    @break
                    @endswitch
                </td>
                <td data-label="وزن">{{$Info->info['weight']}}</td>
                @if ($selecteduserrole->role == 'chief_worker')
                <td data-label="دستمزد سرتیم">{{$Info->info['chiefprice']}}</td>
                @endif
                <td data-label="دستمزد کارگر">{{$Info->info['workerprice']}}</td>
                <td data-label="تاریخ">{{ jdate($Info->JobDate)->format('Y/m/d') }}</td>
            </tr>
            @endforeach
            @else
            <tr>
                @if ($selecteduserrole->role == 'chief_worker')
                <td colspan="6" class="noinfotable">سابقه ای یافت نشد</td>
                @else
                <td colspan="5" class="noinfotable">سابقه ای یافت نشد</td>
                @endif
            </tr>
            @endif

        </tbody>
    </table>
</div>
@if($UserRequests instanceof \Illuminate\Pagination\LengthAwarePaginator && $UserRequests->lastPage() > 1)
<div class="mt-3">
    {{ $UserRequests->appends(request()->query())->links() }}
</div>
@endif