@extends('layouts.index')
@section('js-part')
<script src="{{ asset('assets/js/city.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script src="{{asset('assets/js/edit.contractor.js')}}"></script>
@endsection
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
@endsection

@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">ویرایش درخواست</h2>
    @include('layouts.notification.error')
    @include('contractor.info.table')
    @include('contractor.info.step')

    <form action="{{route('contractor.post.accept')}}" method="post" id="editForm">
        {{csrf_field()}}

        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="transportation" class="mb-2">انتخاب راننده</label>
                    <select name="transportation" id="transportation" class="form-control">
                        <option value="0">راننده ای انتخاب نشده</option>
                        @foreach ($allTransporter as $transporter)
                        @if (is_array($RequestInfo->transportation) && $RequestInfo->transportation['user_id'] == $transporter->id)
                        <option value="{{$transporter->id}}" selected>{{$transporter->first_name}} {{$transporter->last_name}}</option>
                        @else
                        <option value="{{$transporter->id}}">{{$transporter->first_name}} {{$transporter->last_name}}</option>
                        @endif
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <label for="steptype" class="mb-2">نوع تغییرات</label>
                <select name="steptype" id="steptype" class="form-control">
                    <option value="1" selected>تایید و ادامه</option>
                    <option value="2">ویرایش</option>
                </select>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6 d-flex">
                @php
                list($weight,$unit) = explode(" ",$RequestInfo->weight['farmer']);
                @endphp
                <div class="form-group">
                    <label for="weight" class="mb-2">وزن سفارش</label>
                    <input type="number" step=0.01 class="form-control" name="weight" id="weight" placeholder="ویرایش وزن اعلامی" value="{{$weight}}" required>
                </div>
                <div class="form-group ms-2">
                    <label for="weight" class="mb-2">واحد وزن</label>
                    <select class="form-control" name="weightUnit" id="weightUnit" value="{{$unit}}">
                        <option value="کیلوگرم">کیلوگرم</option>
                        <option value="گرم">گرم</option>
                    </select>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <label for="priceperunit" class="mb-2">قیمت هر واحد (تومان):</label>
                <input type="text" dir="ltr" class="form-control" name="priceperunit" id="priceperunit" placeholder="قیمت هر واحد" value="{{ $RequestInfo->contract['priceperunit'] ?? '' }}" required>
                <input type="hidden" name="price" id="price">
                <label for="priceperunit" class="mt-2" id="pricetext">قیمت را وارد کنید</label>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6 d-flex">
                <div class="form-group">
                    <label for="transportprice" class="mb-2">هزینه حمل و نقل (تومان):</label>
                    <input type="text" dir="ltr" class="form-control" name="transportprice" id="transportprice" placeholder="هزینه حمل و نقل" value="{{ $RequestInfo->transportation['price'] ?? '' }}" required>
                    <input type="hidden" name="priceTrans" id="priceTrans">
                    <label for="transportprice" class="mt-2" id="priceTranstext">قیمت را وارد کنید</label>
                </div>
            </div>
        </div>
        <input type="hidden" name="RequestId" value="{{$RequestInfo->id}}">
        <input type="hidden" name="contract" id="contract">
    </form>
    <div class="mt-3">
        <label for="" class="mb-2">متن قرارداد</label>
        @if ($RequestInfo->contract != null && is_array($RequestInfo->contract))
        @include('layouts.editor.editor',['text' => $RequestInfo->contract['text']])
        @else
        @include('layouts.editor.editor',['text' => $contractText])
        @endif

    </div>

    @if ($RequestInfo->step > -100 && ($RequestInfo->step < 5 && $RequestInfo->step != 2))
        <div class="d-flex justify-content-between align-items-center mt-3 mb-5">
            <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#cancelModal">لغو درخواست</button>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#noteModal">ثبت یادداشت</button>
            <button class="btn btn-success" id="AcceptAndConitinueBtn">ثبت تغییرات</button>

        </div>
        @endif
</div>

<div class="modal fade" id="noteModal" tabindex="-1" aria-labelledby="noteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="noteModalLabel">ثبت یادداشت</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{route('contractor.post.add.note')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="requestId" value="{{$RequestInfo->id}}">
                    <textarea name="note" id="note" rows="10" class=" form-control mb-3"></textarea>
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-outline-primary">ثبت یادداشت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">لغو درخواست</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که لغو شود؟</p>
                <p class="text-danger text-center">در صورت لغو امکان فعالسازی مجدد وجود ندارد</p>
                <form action="{{route('contractor.post.cancel')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="CancelId" value="{{$RequestInfo->id}}">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">لغو درخواست</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection