
<?php $__env->startSection('css-part'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/general.panel.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js-part'); ?>
<script src="<?php echo e(asset('assets/js/city.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/general.panel.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/profile.panel.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('panel'); ?>
<?php echo $__env->make('layouts.header.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.nav.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php
$stateMapping = [
'تهران' => 1,
'گیلان' => 2,
'آذربایجان شرقی' => 3,
'خوزستان' => 4,
'فارس' => 5,
'اصفهان' => 6,
'خراسان رضوی' => 7,
'قزوین' => 8,
'سمنان' => 9,
'قم' => 10,
'مرکزی' => 11,
'زنجان' => 12,
'مازندران' => 13,
'گلستان' => 14,
'اردبیل' => 15,
'آذربایجان غربی' => 16,
'همدان' => 17,
'کردستان' => 18,
'کرمانشاه' => 19,
'لرستان' => 20,
'بوشهر' => 21,
'کرمان' => 22,
'هرمزگان' => 23,
'چهارمحال و بختیاری' => 24,
'یزد' => 25,
'سیستان و بلوچستان' => 26,
'ایلام' => 27,
'کهگلویه و بویراحمد' => 28,
'خراسان شمالی' => 29,
'خراسان جنوبی' => 30,
'البرز' => 31
];

$selectedValue = isset($stateMapping[$farmerInfo->state]) ? $stateMapping[$farmerInfo->state] : 0;
?>
<?php $__env->startSection('container'); ?>
<div class="container">
    <h2 class=" text-center mt-3">اطلاعات کاربری شما</h2>
    <?php echo $__env->make('layouts.notification.success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.notification.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <form action="<?php echo e(route('farmer.post.profile')); ?>" method="post" class="mt-3" id="ProfileEditForm">
        
        <?php echo e(csrf_field()); ?>

        <div class="row">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="phone" class="mb-2">شماره موبایل</label>
                    <input type="text" class="form-control" name="phone" id="phone" value="<?php echo e(auth()->user()->phone); ?>" disabled>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="melli_code" class="mb-2">کد ملی</label>
                    <input type="text" class="form-control" name="melli_code" id="melli_code" value="<?php echo e(auth()->user()->melli_code); ?>" disabled>
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="first_name" class="mb-2">نام</label>
                    <input type="text" class="form-control" name="first_name" id="first_name" value="<?php echo e(auth()->user()->first_name); ?>">
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="last_name" class="mb-2">نام خانوادگی</label>
                    <input type="text" class="form-control" name="last_name" id="last_name" value="<?php echo e(auth()->user()->last_name); ?>">
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="father_name" class="mb-2">نام پدر</label>
                    <input type="text" class="form-control" name="father_name" id="father_name" value="<?php echo e($farmerInfo->father_name); ?>" disabled>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="farm_name" class="mb-2">نام مزرعه</label>
                    <input type="text" class="form-control" name="farm_name" value="<?php echo e($farmerInfo->farm_name); ?>" id="farm_name">
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="state" class="mb-2">استان</label>
                    <select name="state" id="state" class="form-control" onChange="CityList(this.value);">
                        <option value="0">استان</option>
                        <option value="1" <?php echo e($selectedValue == 1 ? 'selected' : ''); ?>>تهران</option>
                        <option value="2" <?php echo e($selectedValue == 2 ? 'selected' : ''); ?>>گیلان</option>
                        <option value="3" <?php echo e($selectedValue == 3 ? 'selected' : ''); ?>>آذربایجان شرقی</option>
                        <option value="4" <?php echo e($selectedValue == 4 ? 'selected' : ''); ?>>خوزستان</option>
                        <option value="5" <?php echo e($selectedValue == 5 ? 'selected' : ''); ?>>فارس</option>
                        <option value="6" <?php echo e($selectedValue == 6 ? 'selected' : ''); ?>>اصفهان</option>
                        <option value="7" <?php echo e($selectedValue == 7 ? 'selected' : ''); ?>>خراسان رضوی</option>
                        <option value="8" <?php echo e($selectedValue == 8 ? 'selected' : ''); ?>>قزوین</option>
                        <option value="9" <?php echo e($selectedValue == 9 ? 'selected' : ''); ?>>سمنان</option>
                        <option value="10" <?php echo e($selectedValue == 10 ? 'selected' : ''); ?>>قم</option>
                        <option value="11" <?php echo e($selectedValue == 11 ? 'selected' : ''); ?>>مرکزی</option>
                        <option value="12" <?php echo e($selectedValue == 12 ? 'selected' : ''); ?>>زنجان</option>
                        <option value="13" <?php echo e($selectedValue == 13 ? 'selected' : ''); ?>>مازندران</option>
                        <option value="14" <?php echo e($selectedValue == 14 ? 'selected' : ''); ?>>گلستان</option>
                        <option value="15" <?php echo e($selectedValue == 15 ? 'selected' : ''); ?>>اردبیل</option>
                        <option value="16" <?php echo e($selectedValue == 16 ? 'selected' : ''); ?>>آذربایجان غربی</option>
                        <option value="17" <?php echo e($selectedValue == 17 ? 'selected' : ''); ?>>همدان</option>
                        <option value="18" <?php echo e($selectedValue == 18 ? 'selected' : ''); ?>>کردستان</option>
                        <option value="19" <?php echo e($selectedValue == 19 ? 'selected' : ''); ?>>کرمانشاه</option>
                        <option value="20" <?php echo e($selectedValue == 20 ? 'selected' : ''); ?>>لرستان</option>
                        <option value="21" <?php echo e($selectedValue == 21 ? 'selected' : ''); ?>>بوشهر</option>
                        <option value="22" <?php echo e($selectedValue == 22 ? 'selected' : ''); ?>>کرمان</option>
                        <option value="23" <?php echo e($selectedValue == 23 ? 'selected' : ''); ?>>هرمزگان</option>
                        <option value="24" <?php echo e($selectedValue == 24 ? 'selected' : ''); ?>>چهارمحال و بختیاری</option>
                        <option value="25" <?php echo e($selectedValue == 25 ? 'selected' : ''); ?>>یزد</option>
                        <option value="26" <?php echo e($selectedValue == 26 ? 'selected' : ''); ?>>سیستان و بلوچستان</option>
                        <option value="27" <?php echo e($selectedValue == 27 ? 'selected' : ''); ?>>ایلام</option>
                        <option value="28" <?php echo e($selectedValue == 28 ? 'selected' : ''); ?>>کهگلویه و بویراحمد</option>
                        <option value="29" <?php echo e($selectedValue == 29 ? 'selected' : ''); ?>>خراسان شمالی</option>
                        <option value="30" <?php echo e($selectedValue == 30 ? 'selected' : ''); ?>>خراسان جنوبی</option>
                        <option value="31" <?php echo e($selectedValue == 31 ? 'selected' : ''); ?>>البرز</option>
                    </select>

                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="city" class="mb-2">شهر</label>
                    <select name="city" class="form-control" id="city">
                        <option value="0">شهر</option>
                    </select>
                </div>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        if (<?php echo $selectedValue; ?> != 0) {
                            CityList(<?php echo $selectedValue; ?>,"<?php echo $farmerInfo->city; ?>");
                        }
                    });
                </script>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12">
                <div class="form-group">
                    <label for="address" class="mb-2">آدرس کامل</label>
                    <input type="text" class="form-control" name="address" id="address" value="<?php echo e($farmerInfo->address); ?>">
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12">
                <div class="form-group">
                    <button type="submit" class="btn btn-success w-100" id="SubmitProfileEditBtn">ویرایش اطلاعات</button>
                </div>
            </div>
        </div>
    </form>

    <h2 class="mt-5">تغییر رمز عبور</h2>
    <form action="<?php echo e(route('farmer.post.password')); ?>" method="post">
        <div class="col-12 col-lg-4">
            <?php echo e(csrf_field()); ?>

            <input type="password" class=" form-control mt-3" name="current_password" id="current_password" placeholder="رمز عبور فعلی">
            <input type="password" class=" form-control mt-3" name="password" id="password" placeholder="رمز عبور جدید">
            <input type="password" class=" form-control mt-3" name="password_confirmation" id="password_confirmation" placeholder="تکرار رمز عبور">
            <button type="submit" class="btn btn-warning w-100 mt-3 mb-5" id="changePasswordBtn">تغییر رمز</button>
        </div>
    </form>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/zarborji/public_html/resources/views/farmer/profile.blade.php ENDPATH**/ ?>