<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class OrderRequest extends FormRequest
{
    public function authorize()
    {
        if (Auth::check() && Auth::user()->role == 'farmer') {
           return true;
        }
        return false;
    }

    public function rules()
    {
        return [
            'weight' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'weight.required' => 'وزن محصول وارد نشده است.'
        ];
    }
}
