<div class="zar-table mt-3">
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>کد سفارش</th>
                <th>نوع درخواست</th>
                <th>وزن</th>
                <th>زمان اتمام</th>
                <th>عملیات</th>
            </tr>
        </thead>
        <tbody>
            @if ($UserRequests->isNotEmpty())
            @foreach ($UserRequests as $Info)
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="کد سفارش">{{$Info->id}}</td>
                <td data-label="نوع درخواست">
                    @switch($Info->type)
                    @case(1)
                    تحویل گل
                    @break
                    @case(2)
                    تحویل پیاز
                    @break
                    @endswitch
                </td>
                <td data-label="وزن">{{$Info->info['weight']}}</td>
                <td data-label="زمان اتمام"><span dir="ltr">{{ $Info->info['enddate'] }}</span></td>
                <td data-label="عملیات">
                    @if ($Info->step > 6)
                    @if($Info->info['vaziat'] == 1)
                    <a href="{{route('chief.edit',['id' => $Info->urid])}}" class="btn btn-primary">ویرایش</a>
                    @else
                    <a href="{{route('chief.info',['id' => $Info->id])}}" class="btn btn-primary">ویرایش</a>
                    @endif
                    @else
                    <a href="{{route('chief.edit',['id' => $Info->urid])}}" class="btn btn-primary">ویرایش</a>
                    @endif

                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="6" class="noinfotable">درخواستی یافت نشد</td>
            </tr>
            @endif

        </tbody>
    </table>
</div>
<div class="mt-3">
    {{ $UserRequests->appends(request()->query())->links() }}
</div>