<div class="zar-table mt-3">
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>کد سفارش</th>
                <th>نام کشاورز</th>
                <th>نوع درخواست</th>
                <th>وزن کلاله تر</th>
                <th>تاریخ ثبت</th>
                <th>عملیات</th>
            </tr>
        </thead>
        <tbody>
            @if ($RequestInfo->isNotEmpty())
            @foreach ($RequestInfo as $Info)
            @php
            $allcolale = 0;
            foreach($Info->weight['chief'] as $chiefweight)
            {
            $allcolale = $allcolale + $chiefweight['کلاله'];
            }
            @endphp
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="کد سفارش">{{$Info->id}}</td>
                <td data-label="نام کشاورز">{{ $Info->first_name }} {{ $Info->last_name }}</td>
                <td data-label="نوع درخواست">
                    @switch($Info->type)
                    @case(1)
                    تحویل گل
                    @break
                    @case(2)
                    تحویل پیاز
                    @break
                    @endswitch
                </td>
                <td data-label="وزن کلاله تر">{{$allcolale}} گرم</td>
                <td data-label="تاریخ ثبت">{{ jdate($Info->created_at)->format('Y/m/d') }}</td>
                <td data-label="عملیات">
                    <a href="{{route('dryer.edit',['id' => $Info->id])}}" class="btn btn-primary">ویرایش</a>
                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="5" class="noinfotable">درخواستی یافت نشد</td>
            </tr>
            @endif

        </tbody>
    </table>
</div>
<div class="mt-3">
    {{ $RequestInfo->links() }}
</div>