<?php

namespace App\Http\Controllers\Distributor;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use App\Models\User;
use App\Models\WorkReq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\Jalalian;

class UserController extends Controller
{
    public function show()
    { 
        $perPage = 25;
        $page = request()->input('page', 1);
        $mcode = request()->input('mcode');
        $phone = request()->input('phone');
        $fname = request()->input('fname');
        $lname = request()->input('lname');
        $query = WorkReq::join('requests', 'requests.id', 'user_requests.request_id')
            ->whereNotNull('user_requests.info')
            ->where('requests.step', 6)
            ->join('users', 'users.id', 'user_requests.user_id')
            ->where('users.role', 'chief_worker')
            ->where(function($q) {
                $q->where('user_requests.info->distributed', '!=', 1)
                  ->orWhereNull('user_requests.info->distributed');
            })
            ->select(
                'user_requests.id as user_request_id',
                'user_requests.info',
                'requests.*',
                'users.first_name',
                'users.last_name',
                'users.melli_code',
                'users.phone'
            );

        if ($mcode) {
            $query->where('users.melli_code', $mcode);
        }

        if ($phone) {
            $query->where('users.phone', $phone);
        }

        if ($fname) {
            $query->where('users.first_name', $fname);
        }

        if ($lname) {
            $query->where('users.last_name', $lname);
        }

        $UserRequests = $query->orderBy('requests.id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);



        foreach ($UserRequests as $UserRequest) {
            $oldinfo = $UserRequest->info;
            if (isset($UserRequest->info['enddate'])) {
                $oldinfo['ispast'] = $this->isPastDate($UserRequest->info['enddate']);
            } else {
                $oldinfo['ispast'] = false;
            }

            $UserRequest->info =  $oldinfo;
        }

        return view('Distributor.index', compact('UserRequests'));
    }

    public function viewEdit($id = null)
    {
        $RequestInfo = AppRequest::where('requests.id', $id)
            ->where('requests.step', 6)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name')
            ->first();

        $UserRequests = WorkReq::where('user_requests.request_id', $id)
            ->join('users', 'users.id', 'user_requests.user_id')
            ->where('users.role', 'chief_worker')
            ->select('user_requests.info', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'users.role', 'users.id')
            ->get();

        if ($RequestInfo !== null) {
            return view('Distributor.edit', compact(['RequestInfo', 'UserRequests']));
        }
        return redirect()->route('distributor.panel');
    }

    public function accept(Request $request)
    {
        $requestId = $request->input('requestId');
        $userId = $request->input('userId');

        if (isset($requestId) && ctype_digit($requestId) && $requestId > 0 && isset($userId) && ctype_digit($userId) && $userId > 0) {
            $UserRequest = WorkReq::where('request_id', $requestId)
                ->where('user_id', $userId)
                ->first();

            if ($UserRequest !== null) {
                $userInfo = $UserRequest->info;

                $userInfo['distributor'] = Auth::id();
                $userInfo['distributor_name'] = Auth::user()->first_name . ' ' .Auth::user()->last_name;
                $userInfo['distributed'] = 1; 

                $UserRequest->info =  $userInfo;

                $UserRequest->save();

                $AllUserRequests = WorkReq::join('requests', 'requests.id', 'user_requests.request_id')
                    ->whereNotNull('user_requests.info')
                    ->where('requests.id', $requestId)
                    ->where('users.role', 'chief_worker')
                    ->select(
                        'user_requests.id as user_request_id',
                        'user_requests.info',
                        'requests.*'
                    )
                    ->get();
                
                $notdistributedcount = 0;
                
                foreach ($AllUserRequests as $OneUserRequest) {
                    if(!isset($OneUserRequest->info['distributed']))
                    {
                        $notdistributedcount += 1;
                    }
                }

                if($notdistributedcount == 0)
                {
                    $RequestInfo = AppRequest::where('id',$requestId)->first();
                    $stepInfo = $RequestInfo->step_info;

                    if (!is_array($stepInfo)) {
                        $stepInfo = [];
                    }

                    $stepInfo[] = [
                        'action' => 'توزیع کننده: ' . Auth::user()->first_name . ' ' . Auth::user()->last_name,
                        'user_id' => Auth::id(),
                        'date' => Jalalian::now()->format('Y/m/d H:i:s')
                    ];

                    $stepInfo[] = [
                        'action' => 'بین سرتیم ها توزیع شد',
                        'user_id' => Auth::id(),
                        'date' => Jalalian::now()->format('Y/m/d H:i:s')
                    ];

                    $RequestInfo->step_info =  $stepInfo;

                    $RequestInfo->save();
                }

                return redirect()->route('distributor.panel')->with('success', 'توزیع شما با موفقیت ثبت شد!');
            }
        }

        return redirect()->route('distributor.panel')->with('error', 'مشکلی در ثبت وضعیت توزیع رخ داد!');
    }

    public function isPastDate($persianDate)
    {

        $dateParts = explode(' ', $persianDate);
        $date = explode('/', $dateParts[0]);
        $time = explode(':', $dateParts[1]);


        $jalali = new Jalalian(
            (int)$date[0], // سال
            (int)$date[1], // ماه
            (int)$date[2], // روز
            (int)$time[0], // ساعت
            (int)$time[1], // دقیقه
            (int)$time[2]  // ثانیه
        );

        return $jalali->toCarbon()->lt(now());
    }

    public function printlist()
    {
        $step = request()->input('userId');

        $query = WorkReq::join('requests', 'requests.id', '=', 'user_requests.request_id')
                        ->join('users','users.id', '=','requests.user_id')
                        ->whereJsonContains('user_requests.info->distributor', Auth::id())
                        ->select('user_requests.info', 'requests.*', 'users.first_name', 'users.last_name', 'users.melli_code');


        $AllRequests = $query->get();

        $filename = "requests_" . date('Y-m-d_H-i-s') . ".csv";

        header("Content-Type: text/csv; charset=utf-8");
        header("Content-Disposition: attachment; filename=$filename");

        $output = fopen('php://output', 'w');

        fputcsv($output, [
            'کد سفارش',
            'نام',
            'نام خانوادگی',
            'کد ملی',
            'وزن توزیع',
            'وضعیت',
            'تاریخ ثبت'
        ]);

        foreach ($AllRequests as $req) {

            $stepName = $req->step;

            switch ($stepName) {
                case 1:
                    $stepName = "درخواست جدید";
                    break;
                case 2:
                    $stepName = "در انتظار تایید کشاورز";
                    break;
                case 3:
                    $stepName = "قرارداد تایید شد";
                    break;
                case 4:
                    $stepName = " در انتظار تحویل";
                    break;
                case 5:
                    $stepName = "در انتظار تایید مرکز فراوری";
                    break;
                case 6:
                    $stepName = "دریافت توسط مرکز فراوری";
                    break;
                case 7:
                    $stepName = "توزیع به سرتیم ها";
                    break;
                case 8:
                    $stepName = "اعلام اتمام کار توسط کارگران";
                    break;
                case 9:
                    $stepName = "اتمام کار توسط همه سرتیم ها";
                    break;
                case 10:
                    $stepName = "دریافت توسط مرکز خشک کن";
                    break;
                case 11:
                    $stepName = "اتمام خشک کردن";
                    break;
                case 12:
                    $stepName = "دریافت توسط واحد بسته بندی";
                    break;
                case 13:
                    $stepName = "اتمام سفارش و ارسال";
                    break;
            }

            fputcsv($output, [
                $req->id,
                $req->first_name,
                $req->last_name,
                $req->melli_code,
                $req->info['weight'],
                $stepName,
                jdate($req->created_at)->format('Y/m/d')
            ]);
        }

        fclose($output);
        exit;
    }
}
