<?php

namespace App\Http\Controllers\Reciever;

use App\Http\Controllers\Controller;
use App\Http\Requests\FRUserAddRequest;
use App\Models\User;
use App\Models\Worker;
use Illuminate\Http\Request;

class WorkerController extends Controller
{
    public function show()
    {
        $user_chief_worker = User::where('role', 'chief_worker')->get();
        $user_worker = User::where('role', 'worker')->get();

        if (request('filter_user')) {
            $user_selected = User::where('users.id', request('filter_user'))
                ->where('users.role', 'chief_worker')
                ->join('user_profiles', 'user_profiles.user_id', 'users.id')
                ->select('users.*', 'user_profiles.sub_users')
                ->first();
            if ($user_selected == null) {
                $user_selected = User::where('users.id', request('filter_user'))
                    ->where('users.role', 'worker')
                    ->first();
            }

            return view('factoryReceiver.user', compact(['user_chief_worker', 'user_worker', 'user_selected']));
        }

        return view('factoryReceiver.user', compact(['user_chief_worker', 'user_worker']));
    }

    public function add(FRUserAddRequest $request)
    {
        $user_input = [
            'first_name' => $request->input('first_name'),
            'last_name' => $request->input('last_name'),
            'melli_code' => $request->input('melli_code'),
            'phone' => $request->input('phone'),
            'username' => $request->input('melli_code'),
            'password' => $request->input('phone'),
            'role' => $request->input('role'),
        ];

        $returned_user = User::create($user_input);

        if ($returned_user !== null) {

            if ($returned_user->role == 'chief_worker') {
                $workerinputs = [
                    'user_id' => $returned_user->id,
                    'sub_users' => []
                ];
                $worker_sub = Worker::create($workerinputs);
            }

            return redirect()->back()->with('success', 'کاربر جدید اضافه شد.');
        }

        return redirect()->back()->with('error', 'مشکلی در افزودن کاربر رخ داد.');
    }

    public function edit(Request $request)
    {
        $userid = $request->input('userid');

        if ($userid !== null && (int) $userid > 0) {
            $UserInfo = User::where('id', $userid)->first();
            $oldrole = $UserInfo->role;
            $UserInfo->first_name = $request->input('first_name');
            $UserInfo->last_name = $request->input('last_name');
            $UserInfo->role = $request->input('role');
            $UserInfo->save();

            if ($oldrole == 'chief_worker' && $request->input('role') == 'worker') {
                $Workerprof = Worker::where('user_id', $userid)->first();
                if ($Workerprof !== null) {
                    $Workerprof->delete();
                }
            } else if ($oldrole == 'worker' && $request->input('role') == 'chief_worker') {
                $subusers = $request->input('subusers');
                if($subusers == null)
                {
                    $subusers = [];
                }

                $inputs = [
                    'user_id' => $userid,
                    'sub_users' => $subusers
                ];
                $Workerprof = Worker::create($inputs);
            } else if ($oldrole == 'chief_worker' && $request->input('role') == 'chief_worker') {
                $Workerprof = Worker::where('user_id', $userid)->first();
                $subusers = $request->input('subusers');
                if($subusers == null)
                {
                    $subusers = [];
                }
                $Workerprof->sub_users = $subusers;
                $Workerprof->save();
            }


            return redirect()->back()->with('success', 'کاربر ویرایش شد.');
        }

        return redirect()->back()->with('error', 'مشکلی در ویرایش رخ داد.');
    }
}
