<?php

namespace App\Http\Controllers\Worker;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Http\Requests\PasswordRequest;
use App\Models\Worker;
use App\Models\WorkReq;
use Morilog\Jalali\Jalalian;

class ProfileController extends Controller
{
    public function show()
    {
        return view('worker.profile');
    }

    public function password(PasswordRequest $request)
    {
        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'password' => $request->input('password')
        ]);

        return back()->with('success', 'رمز عبور تغییر کرد');
    }

    public function status()
    {
        
        $from = request()->input('from');
        $to = request()->input('to');

        if (!empty($from) && !empty($to)) {
            $jDatefrom = Jalalian::fromFormat('Y/m/d', $from)->toCarbon();
            $jDateto = Jalalian::fromFormat('Y/m/d', $to)->toCarbon();

            $perPage = 25;
            $page = request()->input('page', 1);

            $UserRequests = WorkReq::where('user_requests.user_id', Auth::id())
                ->where('user_requests.info->vaziat', 100)
                ->whereDate('user_requests.created_at', '>=', $jDatefrom)
                ->whereDate('user_requests.created_at', '<=', $jDateto)
                ->join('requests', 'requests.id', 'user_requests.request_id')
                ->join('users', 'users.id', 'requests.user_id')
                ->select('user_requests.info', 'user_requests.created_at as JobDate', 'requests.*', 'users.first_name', 'users.last_name')
                ->orderBy('requests.id', 'desc')
                ->paginate($perPage, ['*'], 'page', $page);


            $sumdata = [
                    'worker_price' => 0,
                    'weight' => 0
                ];

            
            foreach ($UserRequests as $key => $req) {
                    if($req->info['vaziat'] == 100)
                    {
                        $sumdata['worker_price'] = $sumdata['worker_price'] + $req->info['workerprice'];
                        $sumdata['weight'] = $sumdata['weight'] + $req->info['weight'];
                    }
            }

            return view('worker.status', compact(['UserRequests', 'sumdata']));
        }

        return view('worker.status');
    }
}
