<?php

namespace App\Http\Controllers\Contractor;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use Illuminate\Http\Request;

class DisagreeController extends Controller
{
    // نمایش موارد مغایرت دار
    public function show()
    {
        $perPage = 25;
        $step = request()->input('step');
        $page = request()->input('page', 1);

        $query = AppRequest::where('requests.step', '<', 0)
            ->where('requests.step', '>', -100)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('contractor.disagreement', compact('RequestInfo'));
    } 

    // نمایش موارد کنسل شده
    public function showCancel()
    {
        $perPage = 25;
        $step = request()->input('step');
        $page = request()->input('page', 1);

        $query = AppRequest::where('requests.step', '<', -100)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('contractor.disagreement', compact('RequestInfo'));
    }
}
