<?php

namespace App\Http\Controllers\Farmer;

use App\Http\Controllers\Controller;
use App\Http\Requests\OrderRequest;
use App\Models\AppRequest;
use App\Models\Farmer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\Jalalian;

class RequestController extends Controller
{
    public function order()
    {
        $farmerInfo = Farmer::where('user_id', Auth::user()->id)->first();
        return view('farmer.addRequest', compact('farmerInfo'));
    }

    public function AddRequest(OrderRequest $request)
    {

        $NewOrder = new AppRequest();
        $NewOrder->user_id = auth()->user()->id;
        $NewOrder->type = $request->input('orderType');
        $NewOrder->weight =  ['farmer' => $request->input('weight') . ' ' . $request->input('weightUnit')];
        $NewOrder->step = 1;

        if ($request->has('wantTransport')) {
            $stepinfo = [];

            $stepinfo[] = [
                'action' => 'نیاز به راننده دارم',
                'user_id' => Auth::id(),
                'date' => Jalalian::now()->format('Y/m/d H:i:s')
            ];

            $NewOrder->step_info = $stepinfo;
        }

        $NewOrder->save();
        return redirect()->route('farmer.panel.order')->with('success', 'سفارش شما با موفقیت ثبت شد.');
    }
}
