<?php

namespace App\Services;

class IppanelService
{
    private $base_url = "https://edge.ippanel.com/v1";
    private $token;
    
    public function __construct($token = null)
    {
        $this->token = $token ?? config('services.ippanel.token');
    }
    
    public function sendPattern($from_number, $pattern_code, $recipients, $params = [])
    {
        $url = $this->base_url . "/api/send";
        
        $data = [
            'sending_type' => 'pattern',
            'from_number' => $from_number,
            'code' => $pattern_code,
            'recipients' => $recipients,
            'params' => $params
        ];
        
        
        $payload = json_encode($data, JSON_UNESCAPED_UNICODE);
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: ' . $this->token,
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload)
        ]);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        
        curl_close($ch);
        
        if ($response === false) {
            throw new \Exception('CURL Error: ' . $error);
        }
        
        $result = json_decode($response, true);
        
        return [
            'success' => $http_code == 200,
            'http_code' => $http_code,
            'response' => $result,
            'error' => $error
        ];
    }
    
    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }
}