<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class RequestsExport implements FromCollection, WithHeadings, WithMapping
{
    protected $requests;

    public function __construct($requests)
    {
        $this->requests = $requests;
    }

    public function collection()
    {
        return $this->requests;
    }

    public function headings(): array
    {
        return [
            'شناسه درخواست',
            'نام کشاورز',
            'نام خانوادگی کشاورز',
            'کد ملی',
            'تلفن',
            'نام مزرعه',
            'استان',
            'شهر',
            'آدرس',
            'نام پدر',
            'مرحله',
            'تاریخ ایجاد'
        ];
    }

    public function map($request): array
    {
        return [
            $request->id,
            $request->first_name,
            $request->last_name,
            $request->melli_code,
            $request->phone,
            $request->farm_name,
            $request->state,
            $request->city,
            $request->address,
            $request->father_name,
            $request->step,
            jdate($request->created_at)->format('Y/m/d')
        ];
    }
}