<?php

namespace App\Http\Controllers\Contractor;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use App\Models\SMS;
use App\Models\User;
use Illuminate\Http\Request;
use App\Services\IppanelService;
use Morilog\Jalali\Jalalian;

class SignController extends Controller
{
    // کنترلر قرارداد
    protected $smsService;

    public function __construct(IppanelService $smsService)
    {
        $this->smsService = $smsService;
    }

    public function sendsms(Request $request)
    {
        try {
            $random_code = rand(10000, 99999);

            $verfication = SMS::firstOrNew(['phone' => $request->input('phone')]);
            $verfication->smscode = $random_code;
            $verfication->save();

            $result = $this->smsService->sendPattern(
                config('services.ippanel.default_from'),
                'nkijq9sdcwqwc02',
                [$request->input('phone')],
                [
                    'code' => $random_code,
                ]
            );

            if ($result['success']) {
                return response()->json([
                    'status' => true,
                    'message' => 'پیامک با موفقیت ارسال شد',
                    'data' => $result
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'error' => 'خطا در ارسال پیامک. لطفا دوباره تلاش کنید',
                    'details' => $result
                ], 500);
            }
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'error' => 'خطا در ارسال پیامک. لطفا دوباره تلاش کنید',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function validateSms(Request $request)
    {
        $smscode = $request->input('smscode');
        $user_id = $request->input('user_id');
        $req_id = $request->input('request_id');

        if ($smscode != null && ctype_digit($smscode) && $user_id != null && ctype_digit($user_id) && $req_id != null && ctype_digit($req_id)) {
            
            $RequestInfo = AppRequest::find($req_id);
            $user = User::find($user_id);
            $temp_sms = SMS::where('phone', $user->phone)->first();

            if ($temp_sms->smscode == $smscode) {
                $contract = (object) $RequestInfo->contract;
                $contract->isAccepted = true;
                $contract->acceptedDate = Jalalian::now()->format('Y/m/d H:i:s');

                if ($RequestInfo->contract['lastStep'] != null) {
                    $RequestInfo->step = $RequestInfo->contract['lastStep'];
                    $contract->lastStep = null;
                } else {
                    $oldstep = $RequestInfo->step;
                    $RequestInfo->step = $oldstep + 2;
                }
                $RequestInfo->contract = $contract;

                $RequestInfo->save();
                return redirect()->back();
            } else {
                return redirect()->back()->with('error', 'کد یکبار مصرف صحیح نمی باشد');
            }
        }

        return redirect()->back();
    }
}
