<?php

namespace App\Http\Controllers\Dryer;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Worker;
use App\Models\WorkReq;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\Jalalian;

class UserController extends Controller
{
    public function show()
    {
        $perPage = 25;
        $page = request()->input('page', 1);
        $query = AppRequest::where('requests.step', 9)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('dryer.index', compact('RequestInfo'));
    }

    public function viewEdit($id = null)
    {
        if ($id != null && (int) $id > 0) {
            $RequestInfo = AppRequest::where('requests.id', $id)
                ->join('users', 'requests.user_id', '=', 'users.id')
                ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
                ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name')
                ->first();
            
            $Chief_Workers = WorkReq::where('user_requests.request_id',$id)
                            ->join('users', 'user_requests.user_id', '=', 'users.id')
                            ->where('users.role','chief_worker')
                            ->select('users.id','users.first_name','users.last_name')
                            ->get();

            return view('dryer.edit', compact(['RequestInfo','Chief_Workers']));
        }

        return redirect()->route('dryer.panel');
    }

    public function accept(Request $request)
    {
        $colale = $request->colale;
        $reqid = $request->requestId;
        $RequestInfo = AppRequest::where('id', $reqid)->first();

        WorkReq::where('user_requests.request_id', $reqid)
                    ->join('users', 'users.id', 'user_requests.user_id')
                    ->where('users.role', 'chief_worker')
                    ->update([
                        'info->vaziat' => 100
                    ]);

        $RequestInfo->step = 10;

        

        $stepInfo = $RequestInfo->step_info;

        if (!is_array($stepInfo)) {
            $stepInfo = [];
        }

        $stepInfo[] = [
            'action' => 'واحد خشک کن ' . Auth::user()->first_name . ' ' . Auth::user()->last_name . ' کلاله را تحویل گرفت.',
            'user_id' => Auth::id(),
            'date' => Jalalian::now()->format('Y/m/d H:i:s')
        ];

        $RequestInfo->step_info =  $stepInfo;

        $oldweight = $RequestInfo->weight;

        $oldweight['dryer'] = [
                    'کلاله' => $colale
                ]; 
        $RequestInfo->weight = $oldweight;

        $RequestInfo->save();

        return redirect()->route('dryer.panel');
    }

    public function current()
    {
        $perPage = 25;
        $page = request()->input('page', 1);
        $query = AppRequest::where('requests.step', 10)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('dryer.index', compact('RequestInfo'));
    }

    public function currentAccept(Request $request)
    {
        $safrane = $request->safrane;
        $priceunit = $request->priceunit;
        $reqid = $request->requestId;
        $RequestInfo = AppRequest::where('id', $reqid)->first();

        $RequestInfo->step = 11;

        $stepInfo = $RequestInfo->step_info;

        if (!is_array($stepInfo)) {
            $stepInfo = [];
        }

        $stepInfo[] = [
            'action' => 'واحد خشک کن ' . Auth::user()->first_name . ' ' . Auth::user()->last_name . ' کار را تمام کرد.',
            'user_id' => Auth::id(),
            'date' => Jalalian::now()->format('Y/m/d H:i:s')
        ];

        $RequestInfo->step_info =  $stepInfo;

        $oldweight = $RequestInfo->weight;

        $oldweight['dryer']['زعفران'] = $safrane; 

        $RequestInfo->weight = $oldweight;

        $contract = $RequestInfo->contract;

        if(!is_array($contract))
        {
            $contract = json_decode($contract, true);
        }

        $dryerprice = (int) $priceunit * (int) $safrane;

        $contract['dryerprice'] = $dryerprice;
        $contract['dryerpriceunit'] = $priceunit;

        $RequestInfo->contract = $contract;

        $RequestInfo->save();

        return redirect()->route('dryer.panel');
    }

    public function oldlist()
    {
        $perPage = 25;
        $page = request()->input('page', 1);
        $query = AppRequest::where('requests.step', '>' , 10)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $RequestInfo = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('dryer.index', compact('RequestInfo'));
    }

    public function disagree(Request $request)
    {
        $RequestInfo = AppRequest::where('id', $request->reqId)->first();

        $stepInfo = $RequestInfo->step_info;

        if (!is_array($stepInfo)) {
            $stepInfo = [];
        }

        $stepInfo[] = [
            'action' => 'اعلام مغایرت توسط ' . Auth::user()->first_name . ' ' . Auth::user()->last_name . ' توضیح: ' . $request->reason,
            'user_id' => Auth::id(),
            'date' => Jalalian::now()->format('Y/m/d H:i:s')
        ];

        $RequestInfo->step_info =  $stepInfo;

        $oldstep =  $RequestInfo->step;

        if ((int) $oldstep > 0) {
            $RequestInfo->step = $oldstep * -1;
        }
        $RequestInfo->save();

        return redirect()->route('dryer.panel');
    }
}
