<?php

namespace App\Http\Controllers\Farmer;

use App\Http\Controllers\Controller;
use App\Http\Requests\PasswordRequest;
use App\Http\Requests\ProfileRequest;
use App\Models\Farmer;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    public function show()
    {
        $farmerInfo = Farmer::where('user_id', Auth::id())->first();
        return view('farmer.profile', compact('farmerInfo'));
    }

    public function edit(ProfileRequest $request)
    {
        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'first_name' => $request->input('first_name'),
            'last_name' => $request->input('last_name')
        ]);

        Farmer::where('user_id', Auth::id())->update([
            'state' => $request->input('state'),
            'city' => $request->input('city'),
            'address' => $request->input('address'),
            'farm_name' => $request->input('farm_name')
        ]);

        return back()->with('success','اطلاعات کاربری شما ویرایش شد.');
    }

    public function password(PasswordRequest $request)
    {
        $edit_user = User::find(Auth::id());
        $edit_user->update([
            'password' => $request->input('password')
        ]);
        
        return back()->with('success','رمز عبور تغییر کرد');
    }
}
