$(document).ready(function () {
    $("#sendsmsbtn").click(function () {
        $.ajax({
            url: "/c/send",
            method: "POST",
            dataType: "json",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf_meta"]').attr("content"),
            },
            data: {
                phone: $('#phone').val()
            },
            success: function (response) {
                if (response.status) {
                    $("#isreaded").attr("disabled", "true");
                    $("#step1").removeClass("d-block");
                    $("#step1").removeClass("d-lg-flex");
                    $("#step1").addClass("d-none");
                    $("#step2").removeClass("d-none");
                    $("#step2").addClass("d-block");
                    $("#step2").addClass("d-lg-flex");
                } else {
                    Swal.fire({
                        title: "اخطار زربرج",
                        text: response.error,
                        icon: "error",
                        confirmButtonText: "متوجه شدم",
                    });
                }
            },
            error: function (error) {
                let errorsAll = JSON.parse(error.responseText);
                let inpid = null;
                $.each(errorsAll.errors, function (index, error) {
                    inpid = "#" + index + "_error";
                    $(inpid).html(error).show();
                });
            },
        });
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const isreadedInput = document.getElementById("isreaded");
    isreadedInput.addEventListener("change", function () {
        const ersalbutton = document.getElementById("sendsmsbtn");
        if (isreadedInput.checked) {
            ersalbutton.removeAttribute("disabled");
        } else {
            ersalbutton.setAttribute("disabled", "true");
        }
    });
});
