@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
@endsection
@section('js-part')
<script src="{{ asset('assets/js/city.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script>
    const AcceptButton = document.getElementById("contractBtn");
    AcceptButton.addEventListener("click", function (e) {
        e.preventDefault();
        const ContractDiv = document.getElementById("editor");
        const ContractInput = document.getElementById("contract");
        const editForm = document.getElementById("contractForm");
        ContractInput.value = ContractDiv.innerHTML;
        editForm.submit();
    });
</script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">تنظیمات سایت شما</h2>
    @include('layouts.notification.success')
    @include('layouts.notification.error')
     
    @include('layouts.editor.editor',['text' => $contract])

    <form action="{{route('admin.post.contract')}}" method="post" class="mt-3" id="contractForm">
        {{csrf_field()}}
        <input type="hidden" name="contract" id="contract">
        <button type="submit" class=" btn btn-success" id="contractBtn">ذخیره قرارداد</button>
    </form>

    <form action="{{route('admin.post.salary')}}" method="post" class="mt-4 mb-5">
        {{csrf_field()}}
        <div class="row">
            <div class="group-control col-4">
                <label for="chiefWorkerPrice">دستمزد سرکارگر</label>
                <input type="number" class=" form-control" name="chiefWorkerPrice" id="chiefWorkerPrice" value="{{$chiefworker_salary}}">
            </div>
            <div class="group-control col-4">
                <label for="workerPrice">دستمزد کارگر</label>
                <input type="number" class=" form-control" name="workerPrice" id="workerPrice" value="{{$worker_salary}}">
            </div>
        </div>
        <button type="submit" class=" btn btn-success mt-3" id="contractBtn">ذخیره دستمزدها</button>
    </form>


</div>
@endsection
