@php
    $weighttext = $RequestInfo->info['weight'];
    list($oldweight, $oldunit) = explode(" ", $weighttext);
@endphp

<input type="hidden" id="oldweight" value="{{$oldweight}}">
<form action="{{route('chief.post.accept')}}" method="post" class="mt-3 mb-5" id="EditForm">
    {{csrf_field()}}
    <input type="hidden" name="requestId" value="{{$RequestInfo->id}}">
    <strong class="mb-2"> تخصیص به کارگر (مبالغ برحسب تومان):</strong>
    <div class="zar-table mt-3">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>کارگر</th>
                    <th>وزن</th>
                    <th>دستمزد کارگر</th>
                    <th>تاریخ اتمام</th>
                </tr>
            </thead>
            <tbody id="FormBodyTable">
                <tr>
                    <td data-label="#"><i class="fa-solid fa-circle-plus fa-lg addrow" style="color: #74C0FC; cursor: pointer;"></i></td>
                    <td data-label="کارگر">
                        <select name="worker[]" id="worker_1" class="form-control" required>
                            @foreach ($user_workers as $user_worker)
                            <option value="{{$user_worker->id}}">{{$user_worker->first_name}} {{$user_worker->last_name}}</option>
                            @endforeach
                        </select>
                    </td>
                    <td data-label="وزن">
                        <div class="d-flex">
                            <input type="number" name="weight[]" id="weight[]" class="form-control" step=0.01 placeholder="وزن" required>
                            <select name="weightUnit[]" id="weighUnit[]" class="form-control ms-2">
                                <option value="کیلوگرم">کیلوگرم</option>
                                <option value="گرم">گرم</option>
                            </select>
                        </div>
                    </td>
                    <td data-label="دستمزد کارگر">
                        <input type="text" name="workerprice1[]" id="workerprice1[]" class="form-control" placeholder="دستمزد کارگر" disabled value="{{number_format($worker_salary)}}">
                        <input type="hidden" name="workerprice[]" id="workerprice[]"  value="{{$worker_salary}}">
                    </td>
                    <td data-label="تاریخ اتمام">
                        <input type="text" name="enddate[]" id="enddate[]" class="form-control" placeholder="تاریخ اتمام" dir="ltr" data-jdp required>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="d-flex mt-3 justify-content-between">
       <!-- <span class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#disagreeModal">اعلام مغایرت</span> -->
        <button type="submit" class="btn btn-success" id="SubmitFormBtn">تایید و ادامه</button>
    </div>
</form>
 
<div class="modal fade" id="disagreeModal" tabindex="-1" aria-labelledby="disagreeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="disagreeModalLabel">اعلام مغایرت</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که مغایرت اعلام کنید؟</p>
                <form action="{{route('chief.post.disagree')}}" method="post">
                    {{csrf_field()}}
                    <input type="hidden" name="reqId" value="{{$RequestInfo->id}}">
                    <label for="reason" class="mb-2">علت مغایرت:</label>
                    <textarea name="reason" id="reason" cols="30" rows="5" class="form-control" required></textarea>
                    <div class="d-flex justify-content-center mt-3">
                        <button type="submit" class="btn btn-danger">ثبت مغایرت</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>