@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<link rel="stylesheet" href="{{ asset('assets/css/request.panel.css') }}">
@endsection
@section('js-part')
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script src="{{ asset('assets/js/request.panel.js') }}"></script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    @include('layouts.notification.success')
    @include('layouts.notification.error')
    <h2 class=" text-center mt-3">ثبت سفارش جدید</h2>
    @if ($errors->any())
    <div id='step-1' style="display: none;">
        @else
        <div id='step-1'>
            @endif

            <div class="info-request">
                <h4>لطفا مشخصات ثبت شده خود را مطالعه کنید:</h4>
                <h5 class="ms-2 mt-3 text-danger">* درصورت نیاز به اصلاح اطلاعات گزینه <span class="text-primary">ویرایش اطلاعات</span> را بزنید</h5>
                <h5 class="ms-2 mt-3 text-danger">* درصورت صحیح بودن اطلاعات گزینه <span class="text-primary">تایید و ادامه</span> را بزنید</h5>
            </div>

            @include('farmer.partial.form.table',$farmerInfo)

            <div class="d-flex justify-content-between align-items-center mt-3">
                <a href="{{ route('farmer.profile') }}" class="btn btn-warning">ویرایش اطلاعات</a>
                <button id="acceptAndContinue" class="btn btn-success">تایید و ادامه</button>
            </div>
        </div>

        @if ($errors->any())
        <div id="step-2">
            @else
            <div id="step-2" style="display: none;">
                @endif
                <div class="info-request">
                    <h4>لطفا در فرم زیر موارد خواسته شده را وارد کنید:</h4>
                </div>
                @include('layouts.notification.error')
                <form action="{{route('farmer.post.request')}}" method="post">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-12 col-md-4">
                            <div class="form-group">
                                <label for="orderType" class="mb-2">نوع درخواست</label>
                                <select class="form-control" name="orderType" id="orderType">
                                    <option value="1">تحویل گل</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12 col-md-4 mt-3 mt-md-0">
                            <div class="form-group">
                                <label for="weight" class="mb-2">وزن محصول</label>
                                <!-- <input type="number" step=0.01 class="form-control" name="weight" min=6
                                oninvalid="this.setCustomValidity('وزن گل باید حداقل 6 کیلوگرم باشد')"
                                oninput="this.setCustomValidity('')"
                                id="weight" placeholder="وزن محصول"> -->
                                <input type="number" step=0.01 class="form-control" name="weight" id="weight" placeholder="وزن محصول">
                            </div>
                        </div>
                        <div class="col-12 col-md-4 mt-3 mt-md-0">
                            <div class="form-group">
                                <label for="weightUnit" class="mb-2">واحد وزن</label>
                                <select class="form-control" name="weightUnit" id="weightUnit">
                                    <option value="کیلوگرم">کیلوگرم</option>
                                    <option value="گرم">گرم</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 form-group">
                        <input type="checkbox" name="wantTransport" id="wantTransport" class="form-check-input">
                        <label for="wantTransport" class=" form-check-label">نیاز به راننده دارم</label>
                    </div>
                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-outline-success">ثبت سفارش جدید</button>
                    </div>

                </form>
            </div>


        </div>
        @endsection