@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
@endsection
@section('js-part')
<script src="{{ asset('assets/js/city.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script src="{{asset('assets/js/edit.contractor.js')}}"></script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">ویرایش درخواست</h2>
    @include('layouts.notification.error')
    @include('contractor.info.table')
    @include('contractor.info.step')

    <form action="{{route('contractor.post.accept')}}" method="post" id="editForm">
        {{csrf_field()}}

        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="transportation" class="mb-2">انتخاب راننده</label>
                    <select name="transportation" id="transportation" class="form-control">
                        <option value="0">راننده ای انتخاب نشده</option>
                        @foreach ($allTransporter as $transporter)
                        @if (is_array($RequestInfo->transportation) && $RequestInfo->transportation['user_id'] == $transporter->id)
                        <option value="{{$transporter->id}}" selected>{{$transporter->first_name}} {{$transporter->last_name}}</option>
                        @else
                        <option value="{{$transporter->id}}">{{$transporter->first_name}} {{$transporter->last_name}}</option>
                        @endif
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="weight" class="mb-2">وزن سفارش (واحد وزن را هم بنویسید)</label>
                    <input type="text" class="form-control" name="weight" id="weight" placeholder="ویرایش وزن اعلامی" value="{{$RequestInfo->weight['farmer']}}" required>
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <label for="steptype" class="mb-2">نوع تغییرات</label>
                <select name="steptype" id="steptype" class="form-control">
                    <option value="1" selected>تایید و ادامه</option>
                    <option value="2">ویرایش</option>
                </select>
            </div>
        </div>
        <input type="hidden" name="RequestId" value="{{$RequestInfo->id}}">
        <input type="hidden" name="contract" id="contract">
    </form>
    <div class="mt-3">
        <label for="" class="mb-2">متن قرارداد</label>
        @if ($RequestInfo->contract != null && is_array($RequestInfo->contract))
        @include('layouts.editor.editor',['text' => $RequestInfo->contract['text']])
        @else
        @include('layouts.editor.editor')
        @endif

    </div>

    @if ($RequestInfo->step > -100) 
    <div class="d-flex justify-content-between align-items-center mt-3 mb-5">
        <form action="{{route('contractor.post.cancel')}}" method="post">
            {{csrf_field()}}
            <input type="hidden" name="CancelId" value="{{$RequestInfo->id}}">
            <button type="submit" class="btn btn-danger" id="CancelOrderBtn">لغو درخواست</button>
        </form>
        <button class="btn btn-success" id="AcceptAndConitinueBtn">ثبت تغییرات</button>

    </div>
    @endif
</div>
@endsection