
<?php $__env->startSection('js-part'); ?>
<script src="<?php echo e(asset('assets/js/city.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/general.panel.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/edit.contractor.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css-part'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/css/general.panel.css')); ?>">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('panel'); ?>
<?php echo $__env->make('layouts.header.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.nav.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('container'); ?>
<div class="container">
    <h2 class=" text-center mt-3">ویرایش درخواست</h2>
    <?php echo $__env->make('layouts.notification.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('contractor.info.table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('contractor.info.step', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <form action="<?php echo e(route('contractor.post.accept')); ?>" method="post" id="editForm">
        <?php echo e(csrf_field()); ?>


        <div class="row mt-3">
            <div class="col-12 col-lg-6">
                <div class="form-group">
                    <label for="transportation" class="mb-2">انتخاب راننده</label>
                    <select name="transportation" id="transportation" class="form-control">
                        <option value="0">راننده ای انتخاب نشده</option>
                        <?php $__currentLoopData = $allTransporter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transporter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(is_array($RequestInfo->transportation) && $RequestInfo->transportation['user_id'] == $transporter->id): ?>
                        <option value="<?php echo e($transporter->id); ?>" selected><?php echo e($transporter->first_name); ?> <?php echo e($transporter->last_name); ?></option>
                        <?php else: ?>
                        <option value="<?php echo e($transporter->id); ?>"><?php echo e($transporter->first_name); ?> <?php echo e($transporter->last_name); ?></option>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <label for="steptype" class="mb-2">نوع تغییرات</label>
                <select name="steptype" id="steptype" class="form-control">
                    <option value="1" selected>تایید و ادامه</option>
                    <option value="2">ویرایش</option>
                </select>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6 d-flex">
                <?php
                list($weight,$unit) = explode(" ",$RequestInfo->weight['farmer']);
                ?>
                <div class="form-group">
                    <label for="weight" class="mb-2">وزن سفارش</label>
                    <input type="number" step=0.01 class="form-control" name="weight" id="weight" placeholder="ویرایش وزن اعلامی" value="<?php echo e($weight); ?>" required>
                </div>
                <div class="form-group ms-2">
                    <label for="weight" class="mb-2">واحد وزن</label>
                    <select class="form-control" name="weightUnit" id="weightUnit" value="<?php echo e($unit); ?>">
                        <option value="کیلوگرم">کیلوگرم</option>
                        <option value="گرم">گرم</option>
                    </select>
                </div>
            </div>
            <div class="col-12 col-lg-6 mt-3 mt-lg-0">
                <label for="priceperunit" class="mb-2">قیمت هر واحد (تومان):</label>
                <input type="text" dir="ltr" class="form-control" name="priceperunit" id="priceperunit" placeholder="قیمت هر واحد" value="<?php echo e($RequestInfo->contract['priceperunit'] ?? ''); ?>" required>
                <input type="hidden" name="price" id="price">
                <label for="priceperunit" class="mt-2" id="pricetext">قیمت را وارد کنید</label>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12 col-lg-6 d-flex">
                <div class="form-group">
                    <label for="transportprice" class="mb-2">هزینه حمل و نقل (تومان):</label>
                    <input type="text" dir="ltr" class="form-control" name="transportprice" id="transportprice" placeholder="هزینه حمل و نقل" value="<?php echo e($RequestInfo->transportation['price'] ?? ''); ?>" required>
                    <input type="hidden" name="priceTrans" id="priceTrans">
                    <label for="transportprice" class="mt-2" id="priceTranstext">قیمت را وارد کنید</label>
                </div>
            </div>
        </div>
        <input type="hidden" name="RequestId" value="<?php echo e($RequestInfo->id); ?>">
        <input type="hidden" name="contract" id="contract">
    </form>
    <div class="mt-3">
        <label for="" class="mb-2">متن قرارداد</label>
        <?php if($RequestInfo->contract != null && is_array($RequestInfo->contract)): ?>
        <?php echo $__env->make('layouts.editor.editor',['text' => $RequestInfo->contract['text']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
        <?php echo $__env->make('layouts.editor.editor',['text' => $contractText], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

    </div>

    <?php if($RequestInfo->step > -100 && ($RequestInfo->step < 5 && $RequestInfo->step != 2)): ?>
        <div class="d-flex justify-content-between align-items-center mt-3 mb-5">
            <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#cancelModal">لغو درخواست</button>
            <button class="btn btn-success" id="AcceptAndConitinueBtn">ثبت تغییرات</button>

        </div>
        <?php endif; ?>
</div>

<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">لغو درخواست</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که لغو شود؟</p>
                <p class="text-danger text-center">در صورت لغو امکان فعالسازی مجدد وجود ندارد</p>
                <form action="<?php echo e(route('contractor.post.cancel')); ?>" method="post">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="CancelId" value="<?php echo e($RequestInfo->id); ?>">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">لغو درخواست</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/zarborji/public_html/resources/views/contractor/edit.blade.php ENDPATH**/ ?>