<?php if($paginator->hasPages()): ?>
    <nav aria-label="Page navigation">
        <ul class="pagination justify-content-center">
            
            <?php if($paginator->onFirstPage()): ?>
                <li class="page-item disabled" aria-disabled="true">
                    <span class="page-link">« قبلی</span>
                </li>
            <?php else: ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev">« قبلی</a>
                </li>
            <?php endif; ?>

            
            <?php
                $current = $paginator->currentPage();
                $last = $paginator->lastPage();
                $window = 3; 
                
                $start = max(1, $current - $window);
                $end = min($last, $current + $window);
                
                
                if ($current <= $window + 1) {
                    $end = min($last, 2 * $window + 1);
                }
                
                
                if ($current >= $last - $window) {
                    $start = max(1, $last - 2 * $window);
                }
                
                $showDots = $last > ($window * 2 + 3);
            ?>

          
            <?php if($showDots && $start > 1): ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($paginator->url(1)); ?>">1</a>
                </li>
                <?php if($start > 2): ?>
                    <li class="page-item disabled">
                        <span class="page-link">...</span>
                    </li>
                <?php endif; ?>
            <?php endif; ?>

           
            <?php for($i = $start; $i <= $end; $i++): ?>
                <?php if($i == $paginator->currentPage()): ?>
                    <li class="page-item active" aria-current="page">
                        <span class="page-link"><?php echo e($i); ?></span>
                    </li>
                <?php else: ?>
                    <li class="page-item">
                        <a class="page-link" href="<?php echo e($paginator->url($i)); ?>"><?php echo e($i); ?></a>
                    </li>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if($showDots && $end < $last): ?>
                <?php if($end < $last - 1): ?>
                    <li class="page-item disabled">
                        <span class="page-link">...</span>
                    </li>
                <?php endif; ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($paginator->url($last)); ?>"><?php echo e($last); ?></a>
                </li>
            <?php endif; ?>

            <?php if($paginator->hasMorePages()): ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next">بعدی »</a>
                </li>
            <?php else: ?>
                <li class="page-item disabled" aria-disabled="true">
                    <span class="page-link">بعدی »</span>
                </li>
            <?php endif; ?>
        </ul>
    </nav>
<?php endif; ?><?php /**PATH /home1/zarborji/public_html/resources/views/layouts/pagination/page.blade.php ENDPATH**/ ?>