$(document).ready(function () {
    const resendBtn = $("#resendCode");
    let timeLeft = 120;
    let countdownInterval;

    function updateTimerDisplay() {
        const minutes = Math.floor(timeLeft / 60);
        const seconds = timeLeft % 60;
        resendBtn.text(`${minutes}:${seconds.toString().padStart(2, "0")}`);
    }

    $("#state").select2({
        theme: "bootstrap-5",
        placeholder: "استان",
        allowClear: false,
        language: "fa",
        width: "100%",
    });

    $("#city").select2({
        theme: "bootstrap-5",
        placeholder: "شهر",
        allowClear: false,
        language: "fa",
        width: "100%",
    });

    function StartTimer() {
        timeLeft = 120;
        resendBtn.removeClass("btn-warning").addClass("btn-secondary");
        countdownInterval = setInterval(function () {
            timeLeft--;
            updateTimerDisplay();

            if (timeLeft <= 0) {
                clearInterval(countdownInterval);
                resendBtn.removeClass("btn-secondary").addClass("btn-warning");
                resendBtn.text("ارسال مجدد");
            }
        }, 1000);
    }

    function sendSms() {
        var formData = $("#RegisterForm").serialize();
        $(".text-danger").hide();
        $.ajax({
            url: "/sendsms",
            method: "POST",
            dataType: "json",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf_meta"]').attr("content"),
            },
            data: formData,
            success: function (response) {
                if (response.status) {
                    $("#step_1").hide();
                    $("#step_2").show();
                    StartTimer();
                } else {
                    Swal.fire({
                        title: "اخطار زربرج",
                        text: response.error,
                        icon: "error",
                        confirmButtonText: "متوجه شدم",
                    });
                }
            },
            error: function (error) {
                let errorsAll = JSON.parse(error.responseText);
                let inpid = null;
                $.each(errorsAll.errors, function (index, error) {
                    inpid = "#" + index + "_error";
                    $(inpid).html(error).show();
                });
            },
        });
    }

    $("#sendsms").click(function () {
        sendSms();
    });

    $("#resendCode").click(function () {
        if ($("#resendCode").is(".btn-warning")) {
            sendSms();
        }
    });

    $("#RegisterForm").on("submit", function (e) {
        e.preventDefault();
        $("#smscode_error").hide();
        let form = $(this);
        var formData = $("#RegisterForm").serialize();
        $.ajax({
            url: "/checksms",
            method: "POST",
            data: formData,
            success: function (response) {
                if (response.success) {
                    const selectState = document.getElementById("state");

                    for (let i = 0; i < selectState.options.length; i++) {
                        let opt = selectState.options[i];
                        opt.value = opt.text;
                    }

                    form.off("submit");
                    form.submit();
                } else {
                    $("#smscode_error")
                        .html("رمز یکبارمصرف وارد شده صحیح نمی باشد.")
                        .show();
                }
            },
            error: function () {
                $("#smscode_error")
                    .html(
                        "مشکلی در ارتباط با سرور ایجاد شده لطفا دوباره تلاش کنید."
                    )
                    .show();
            },
        });
    });
});

document.addEventListener("DOMContentLoaded", function () {
    const TogglePassword = document.getElementById("TogglePass");
    TogglePassword.addEventListener("click", function () {
        if (TogglePassword.classList.contains("fa-eye")) {
            TogglePassword.classList.remove("fa-eye");
            TogglePassword.classList.add("fa-eye-slash");
            document.getElementById("password").type = "text";
        } else {
            TogglePassword.classList.remove("fa-eye-slash");
            TogglePassword.classList.add("fa-eye");
            document.getElementById("password").type = "password";
        }
    });

    const loginDiv = document.getElementById("loginDiv");
    const RegisterDiv = document.getElementById("RegisterDiv");
    const openRegisterTab = document.getElementById("openRegisterTab");

    loginDiv.addEventListener("click", function () {
        if (RegisterDiv.classList.contains("active")) {
            RegisterDiv.classList.remove("active");
        }

        if (!loginDiv.classList.contains("active")) {
            loginDiv.classList.add("active");
        }

        document.getElementById("loginFormDiv").style.display = "block";
        document.getElementById("registerFormDiv").style.display = "none";
    });

    RegisterDiv.addEventListener("click", function () {
        if (loginDiv.classList.contains("active")) {
            loginDiv.classList.remove("active");
        }

        if (!RegisterDiv.classList.contains("active")) {
            RegisterDiv.classList.add("active");
        }

        document.getElementById("loginFormDiv").style.display = "none";
        document.getElementById("registerFormDiv").style.display = "block";
    });

    openRegisterTab.addEventListener("click", function () {
        if (loginDiv.classList.contains("active")) {
            loginDiv.classList.remove("active");
        }

        if (!RegisterDiv.classList.contains("active")) {
            RegisterDiv.classList.add("active");
        }

        document.getElementById("loginFormDiv").style.display = "none";
        document.getElementById("registerFormDiv").style.display = "block";
    });

    const isorder = document.getElementById("isorder");
    isorder.addEventListener("change", function () {
        if (isorder.checked) {
            document.getElementById("weightDiv").style.display = "flex";
        } else {
            document.getElementById("weightDiv").style.display = "none";
        }
    });

    const openNewPassTab = document.getElementById("openNewPassTab");
    const openLogininTab = document.getElementById("openLogininTab");

    openNewPassTab.addEventListener("click", function () {
        document.getElementById("newpassdiv").style.display = 'block';
        document.getElementById("login_div").style.display = 'none';
    });

    openLogininTab.addEventListener("click", function () {
        document.getElementById("newpassdiv").style.display = 'none';
        document.getElementById("login_div").style.display = 'block';
    });

});
