@extends('layouts.index')
@section('css-part')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2-bootstrap-5-theme/1.3.0/select2-bootstrap-5-theme.min.css" />
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<link rel="stylesheet" href="{{ asset('assets/css/reciever.user.css') }}">
@endsection
@section('js-part')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script src="{{ asset('assets/js/reciever.user.js') }}"></script>
<script src="{{ asset('assets/js/chief.user.js') }}"></script>
<script>
    $(document).ready(function() {
        $("#chief").select2({
            theme: "bootstrap-5",
            placeholder: "انتخاب سرتیم",
            allowClear: false,
            language: "fa",
            width: "100%",
        });

        $("#role").on('change', function() {
            $("#chiefDiv").toggle($(this).val() == 'worker');
        });
    });
</script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">مدیریت کاربران</h2>
    <div class="mt-3">
        @include('layouts.notification.success')
        @include('layouts.notification.error')
    </div>

    <div class="user-div mt-3">
        <div class="user-header">
            @if(request('page') || request('userId') || request('first_name') || request('last_name') || request('phone') || request('melli_code') || request('role'))
            <div class="col-6 user-header-btn" id="newUserDiv">
                @else
                <div class="col-6 user-header-btn active" id="newUserDiv">
                    @endif

                    <h4>افزودن کاربر</h4>
                </div>

                @if(request('page') || request('userId') || request('first_name') || request('last_name') || request('phone') || request('melli_code') || request('role'))
                <div class="col-6 user-header-btn active" id="editUserDiv">
                    @else
                    <div class="col-6 user-header-btn" id="editUserDiv">
                        @endif
                        <h4>ویرایش کاربر</h4>
                    </div>
                </div>
                <div class="user-body">
                    @if(request('page') || request('userId') || request('first_name') || request('last_name') || request('phone') || request('melli_code') || request('role'))
                    <div id="newUserFormDiv" style="display: none;">
                        @else
                        <div id="newUserFormDiv" style="display: block;">
                            @endif
                            @include('Admin.user.add')
                        </div>
                        @if(request('page') || request('userId') || request('first_name') || request('last_name') || request('phone') || request('melli_code') || request('role'))
                        <div id="editUserFormDiv" style="display: block;">
                            @else
                            <div id="editUserFormDiv" style="display: none;">
                                @endif
                                @include('Admin.user.filter')
                                @include('Admin.user.table')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection