@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
@endsection
@section('js-part')
<script src="{{ asset('assets/js/city.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script src="{{asset('assets/js/edit.contractor.js')}}"></script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    <h2 class=" text-center mt-3">ثبت تحویل </h2>
    @include('layouts.notification.error')
    @include('layouts.notification.success')
    @include('transporter.info.table')

    <form action="{{route('transporter.post.accept')}}" method="post" class="mb-5">
        {{csrf_field()}}
        <div class="row mt-3">
            <div class="col-12 col-lg-4">
                <div class="form-group">
                    <label for="melli_code" class="mb-2">کد ملی کشاورز</label>
                    <input type="text" name="melli_code" id="melli_code" class="form-control" placeholder="کد ملی کشاورز">
                    <input type="hidden" name="requestId" value="{{$RequestInfo->id}}">
                </div>
            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="weight" class="mb-2">درصورت امکان وزن را وارد کنید:</label>
                    <input type="text" name="weight" id="weight" class="form-control" placeholder="وزن محصول درصورت امکان وزن کشی">
                </div>
            </div>
            <div class="col-12 col-lg-4 mt-3 mt-lg-0">
                <div class="form-group">
                    <label for="weight" class="mb-2">واحد وزن:</label>
                    <select name="unit" class="form-control" id="unit">
                        <option value="کیلوگرم">کیلوگرم</option>
                        <option value="گرم">گرم</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="row mt-3 ps-2 pe-2">
            <button type="submit" class="btn btn-outline-success w-100">تایید تحویل</button>
        </div>
    </form>

</div>
@endsection