<form action="<?php echo e(route('admin.post.edit.user')); ?>" method="post" class="mb-5">
    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="userid" value="<?php echo e($UserInfo->id); ?>">
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="first_name" class="mb-2">نام</label>
                <input type="text" class=" form-control" name="first_name" id="first_name" placeholder="نام" value=" <?php echo e($UserInfo->first_name); ?>">
            </div>
        </div>
        <div class="col-12 col-lg-6 mt-3 mt-lg-0">
            <div class="form-group">
                <label for="last_name" class="mb-2">نام خانوادگی</label>
                <input type="text" class=" form-control" name="last_name" id="last_name" placeholder="نام خانوادگی" value=" <?php echo e($UserInfo->last_name); ?>">
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="melli_code" class="mb-2">کد ملی</label>
                <input type="text" class=" form-control" name="melli_code" id="melli_code" placeholder="کد ملی" value=" <?php echo e($UserInfo->melli_code); ?>">
            </div>
        </div>
        <div class="col-12 col-lg-6 mt-3 mt-lg-0">
            <div class="form-group">
                <label for="phone" class="mb-2">شماره موبایل</label>
                <input type="text" class=" form-control" name="phone" id="phone" placeholder="شماره موبایل" value=" <?php echo e($UserInfo->phone); ?>">
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="username" class="mb-2">نام کاربری</label>
                <input type="text" class=" form-control" name="username" id="username" placeholder="نام کاربری" value=" <?php echo e($UserInfo->username); ?>">
            </div>
        </div>
        <div class="col-12 col-lg-6 mt-3 mt-lg-0">
            <div class="form-group">
                <label for="password" class="mb-2">رمز عبور</label>
                <input type="text" class=" form-control" name="password" id="password" placeholder="رمز عبور">
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-12 col-lg-6">
            <div class="form-group">
                <label for="role" class="mb-2">نقش کاربر</label>
                <select name="role" id="role" class="form-control">
                    <option value="0">انتخاب نقش</option>
                    <option value="transporter" <?php echo e($UserInfo->role == 'transporter' ? 'selected' : ""); ?>>راننده</option>
                    <option value="factory_receiver" <?php echo e($UserInfo->role == 'factory_receiver' ? 'selected' : ""); ?>>مرکز فراوری</option>
                    <option value="contractor" <?php echo e($UserInfo->role == 'contractor' ? 'selected' : ""); ?>>امور قرارداد</option>
                    <option value="chief_worker" <?php echo e($UserInfo->role == 'chief_worker' ? 'selected' : ""); ?>>سرتیم</option>
                    <option value="worker" <?php echo e($UserInfo->role == 'worker' ? 'selected' : ""); ?>>کارگر</option>
                    <option value="dryer" <?php echo e($UserInfo->role == 'dryer' ? 'selected' : ""); ?>>خشک کن</option>
                    <option value="packager" <?php echo e($UserInfo->role == 'packager' ? 'selected' : ""); ?>>بسته بندی</option>
                    <option value="distributor" <?php echo e($UserInfo->role == 'distributor' ? 'selected' : ""); ?>>توزیع کننده</option>
                </select>
            </div>
        </div>
        <?php if($UserInfo->role == 'worker'): ?>
        <div class="col-12 col-lg-6" id="chiefDiv" style="display: block;">
        <?php else: ?>
        <div class="col-12 col-lg-6" id="chiefDiv" style="display: none;">
        <?php endif; ?>
            <div class="form-group">
                <label for="chief" class="mb-2">انتخاب سرتیم</label>
                <select name="chief" id="chief" class="form-control">
                    <option value="0">انتخاب سرتیم</option>
                    <?php $__currentLoopData = $chiefWorkers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chief): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($chief->id); ?>" <?php echo e((isset($selectedchiefWorker->user_id) && $selectedchiefWorker->user_id == $chief->id) ? 'selected' : ''); ?>><?php echo e($chief->first_name); ?> <?php echo e($chief->last_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
    <div class="mt-3 d-flex justify-content-between">
        <span class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#removeModal">حذف کاربر</span>
        <button type="submit" class=" btn btn-success">ویرایش کاربر</button>
    </div>
</form>

<div class="modal fade" id="removeModal" tabindex="-1" aria-labelledby="removeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="removeModalLabel">حذف کاربر</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که کاربر حذف شود؟</p>
                <form action="<?php echo e(route('admin.post.delete.user')); ?>" method="post">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="userId" value="<?php echo e($UserInfo->id); ?>">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">حذف کاربر</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH /home1/zarborji/public_html/resources/views/Admin/user/edit.blade.php ENDPATH**/ ?>