<div class="mt-3">
    <strong class="mb-2">اطلاعات وضعیت ها:</strong>
    <table class="step-table">
        <tr>
            <th class="notprint">#</th>
            <th>کد کاربر</th>
            <th>گزارش</th>
            <td>تاریخ</td>
        </tr>
        <?php if(is_array($RequestInfo->step_info)): ?>
        <?php $__currentLoopData = $RequestInfo->step_info; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $step_info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr id="step<?php echo e($key); ?>">
            <td class="notprint"><i class="fa-solid fa-circle-minus" style="color: #ff0000; cursor: pointer;" data-id="step<?php echo e($key); ?>"></i></td>
            <th>
                <?php if(isset($step_info['user_id'])): ?>
                <?php echo e($step_info['user_id']); ?>

                <?php else: ?>
                -
                <?php endif; ?>

            </th>
            <th><?php echo e($step_info['action']); ?></th>
            <td><?php echo e($step_info['date']); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </table>
</div>

<?php if($RequestInfo->step > 0): ?>


<div class="mt-3 notprint">
    <strong class="mb-2">تغییر وضعیت:</strong>
    <form action="<?php echo e(route('admin.post.step.change')); ?>" method="post">
        <?php echo e(csrf_field()); ?>

        <input type="hidden" name="requestId" value="<?php echo e($RequestInfo->id); ?>">
        <div class="d-flex justify-content-between">
            <div class="form-group">
                <select name="step" id="step" class="form-control">
                    <option value="1" <?php echo e($RequestInfo->step == 1 ? 'selected' : ''); ?>>1. درخواست جدید</option>
                    <option value="2" <?php echo e($RequestInfo->step == 2 ? 'selected' : ''); ?>>2. در انتظار تایید قرارداد</option>
                    <option value="3" <?php echo e($RequestInfo->step == 3 ? 'selected' : ''); ?>>3. تایید قرارداد</option>
                    <option value="4" <?php echo e($RequestInfo->step == 4 ? 'selected' : ''); ?>>4. در انتظار تحویل</option>
                    <option value="5" <?php echo e($RequestInfo->step == 5 ? 'selected' : ''); ?>>5. تایید تحویل راننده</option>
                    <option value="6" <?php echo e($RequestInfo->step == 6 ? 'selected' : ''); ?>>6. تایید دریافت مرکز فراوری</option>
                    <option value="7" <?php echo e($RequestInfo->step == 7 ? 'selected' : ''); ?>>7. تایید دریافت گل توسط سرتیم</option>
                    <option value="8" <?php echo e($RequestInfo->step == 8 ? 'selected' : ''); ?>>8. تایید اتمام توسط کارگر</option>
                    <option value="9" <?php echo e($RequestInfo->step == 9 ? 'selected' : ''); ?>>9. تایید توسط سرتیم و ارسال به واحد خشک کن</option>
                    <option value="10" <?php echo e($RequestInfo->step == 10 ? 'selected' : ''); ?>>10. دریافت توسط خشک کن</option>
                    <option value="11" <?php echo e($RequestInfo->step == 11 ? 'selected' : ''); ?>>11. اتمام خشک کردن</option>
                    <option value="12" <?php echo e($RequestInfo->step == 12 ? 'selected' : ''); ?>>12. تایید دریافت توسط واحد بسته بندی</option>
                    <option value="13" <?php echo e($RequestInfo->step == 13 ? 'selected' : ''); ?>>13. اتمام بسته بندی</option>
                </select>
            </div>
            <div class="form-group">
                <button type="submit" class="btn btn-outline-dark">تغییر وضعیت</button>
            </div>
        </div>

    </form>
</div>
<?php endif; ?>
<div class="mt-3">
    <strong class="mb-2">اطلاعات قرارداد:</strong>
    <table class="step-table">
        <?php if(is_array($RequestInfo->contract) && $RequestInfo->contract['isAccepted']): ?>
        <tr>
            <th>توسط کشاورز تایید شد</th>
            <td><?php echo e($RequestInfo->contract['acceptedDate']); ?></td>
        </tr>
        <?php endif; ?>
        <?php if(is_array($RequestInfo->contract) && isset($RequestInfo->contract['priceperunit'])): ?>
        <tr>
            <th>قیمت واحد</th>
            <?php if(strstr($RequestInfo->contract['priceperunit'],",") || strstr($RequestInfo->contract['priceperunit'],"٬")): ?>
            <td><?php echo e($RequestInfo->contract['priceperunit']); ?></td>
            <?php else: ?>
            <td><?php echo e(number_format((int) $RequestInfo->contract['priceperunit'])); ?></td>
            <?php endif; ?>
        </tr>
        <?php endif; ?>
        <?php if(is_array($RequestInfo->contract) && isset($RequestInfo->contract['pricetotal'])): ?>
        <tr>
            <th>قیمت کل</th>
            <td><?php echo e(number_format($RequestInfo->contract['pricetotal'])); ?> تومان</td>
        </tr>
        <?php endif; ?>
        <?php if(is_array($RequestInfo->transportation) && isset($RequestInfo->transportation['price'])): ?>
        <tr>
            <th>هزینه حمل و نقل</th>
            <td><?php echo e(number_format($RequestInfo->transportation['pricetotal'])); ?> تومان</td>
        </tr>
        <?php endif; ?>
        <?php if(is_array($RequestInfo->contract) && isset($RequestInfo->contract['dryerprice'])): ?>
        <tr>
            <th>هزینه واحد خشک کن</th>
            <td><?php echo e(number_format($RequestInfo->contract['dryerpriceunit'] * $RequestInfo->weight['dryer']['کلاله'])); ?> تومان</td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<div class="mt-3">
    <strong class="mb-2">اطلاعات وزن ها:</strong>
    <table class="step-table">
        <?php if(isset($weightInfo['farmer'])): ?>
        <tr>
            <th>کشاورز</th>
            <td><?php echo e($weightInfo['farmer']); ?></td>
        </tr>
        <?php endif; ?>
        <?php if(isset($weightInfo['transporter'])): ?>
        <tr>
            <th>راننده</th>
            <td><?php echo e($weightInfo['transporter']); ?></td>
        </tr>
        <?php endif; ?>
        <?php if(isset($weightInfo['chief'])): ?>
        <?php $__currentLoopData = $weightInfo['chief']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $weight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <th>سرتیم: <?php echo e($weight['name']); ?></th>
            <td>کلاله تر <?php echo e($weight['کلاله']); ?> گرم - ریشه <?php echo e($weight['ریشه']); ?>گرم - گل <?php echo e($weight['گل']); ?> گرم</td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <?php if(isset($weightInfo['dryer'])): ?>
        <?php if(isset($weightInfo['dryer']['کلاله'])): ?>
        <tr>
            <th>واحد خشک کن</th>
            <td>کلاله تر <?php echo e($weightInfo['dryer']['کلاله']); ?> گرم</td>
        </tr>
        <?php endif; ?>
        <?php if(isset($weightInfo['dryer']['زعفران'])): ?>
        <tr>
            <th>واحد خشک کن</th>
            <td>کلاله خشک <?php echo e($weightInfo['dryer']['زعفران']); ?> گرم</td>
        </tr>
        <?php endif; ?>
        <?php endif; ?>
    </table>
</div>

<div class="mt-3">
    <strong class="mb-2"> کارگران سرتیم ها:</strong>
    <table class="step-table">
        <?php $__currentLoopData = $userSubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userSub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <th><?php echo e($userSub->first_name); ?> <?php echo e($userSub->last_name); ?></th>
            <td><?php echo e(implode(", ",$userSub->sub_users)); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
</div>

<div class="zar-table mt-3">
    <strong class="mb-2">اطلاعات کارکنان:</strong>
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نقش</th>
                <th>کد کارمند</th>
                <th>نام کارمند</th>
                <th>شماره تماس</th>
                <th>کد ملی</th>
                <th>وزن</th>
                <th>قیمت</th>
                <th class="notprint">عملیات</th>
            </tr>
        </thead>
        <tbody>
            <?php if($UserRequests->isNotEmpty()): ?>
            <?php $__currentLoopData = $UserRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td data-label="ردیف"><?php echo e($loop->iteration); ?></td>
                <td data-label="نقش">
                    <?php switch($Info->role):
                    case ('transporter'): ?>
                    راننده
                    <?php break; ?>
                    <?php case ('chief_worker'): ?>
                    سرتیم
                    <?php break; ?>
                    <?php case ('worker'): ?>
                    کارگر
                    <?php break; ?>
                    <?php endswitch; ?>
                </td>
                <td data-label="کد کارمند"><?php echo e($Info->id); ?></td>
                <td data-label="نام کارمند"><?php echo e($Info->first_name); ?> <?php echo e($Info->last_name); ?></td>
                <td data-label="شماره تماس"><?php echo e($Info->phone); ?></td>
                <td data-label="کد ملی"><?php echo e($Info->melli_code); ?></td>
                <td data-label="وزن">
                    <?php if($Info->info != null): ?>
                    <?php echo e($Info->info['weight']); ?>

                    <?php else: ?>
                    -
                    <?php endif; ?>
                </td>
                <td data-label="قیمت">
                    <?php if($Info->info != null): ?>
                    <?php if(isset($Info->info['chiefprice'])): ?>
                    || سرتیم: <?php echo e(number_format($Info->info['chiefprice'])); ?> تومان ||
                    <?php endif; ?>
                    <?php if(isset($Info->info['workerprice'])): ?>
                    || کارگر: <?php echo e(number_format($Info->info['workerprice'])); ?> تومان ||
                    <?php endif; ?>
                    <?php else: ?>
                    -
                    <?php endif; ?>
                </td>
                <td data-label="عملیات" class="notprint">
                    <?php if($Info->role == 'chief_worker'): ?>
                        <form action="<?php echo e(route('admin.post.remove')); ?>" method="post">
                            <?php echo e(csrf_field()); ?>

                            <input type="hidden" name="requestId" value="<?php echo e($RequestInfo->id); ?>">
                            <input type="hidden" name="userId" value="<?php echo e($Info->id); ?>">
                            <button type="submit" class="btn btn-outline-danger">حذف کاربر</button>
                        </form>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <tr>
                <td colspan="8" class="noinfotable">کارمندی یافت نشد</td>
            </tr>
            <?php endif; ?>

        </tbody>
    </table>
</div>

<div class="mt-3">
    <label for="" class="mb-2">متن قرارداد</label>
    <?php if($RequestInfo->contract != null && is_array($RequestInfo->contract)): ?>
    <?php echo $__env->make('layouts.editor.editor',['text' => $RequestInfo->contract['text']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</div>

<div class="justify-content-center mt-3 cancelpart" style="display: flex;">
    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#cancelModal">لغو درخواست</button>
</div>

<div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="cancelModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cancelModalLabel">لغو درخواست</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p class="text-danger text-center">آیا مطمئن هستید که لغو شود؟</p>
                <p class="text-danger text-center">در صورت لغو امکان فعالسازی مجدد وجود ندارد</p>
                <?php if($RequestInfo->step > -100): ?>
                <form action="<?php echo e(route('admin.post.cancel')); ?>" method="post">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="CancelId" value="<?php echo e($RequestInfo->id); ?>">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">لغو درخواست</button>
                    </div>
                </form>
                <?php else: ?>
                <form action="<?php echo e(route('admin.post.delete')); ?>" method="post">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" name="deleteId" value="<?php echo e($RequestInfo->id); ?>">
                    <div class="d-flex justify-content-center">
                        <button type="submit" class="btn btn-danger" id="CancelOrderBtn">حذف درخواست</button>
                    </div>
                </form>
                <?php endif; ?>


            </div>
        </div>
    </div>
</div><?php /**PATH /home1/zarborji/public_html/resources/views/Admin/info/step.blade.php ENDPATH**/ ?>