@extends('layouts.index')
@section('css-part')
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
@endsection
@section('js-part')
<script src="{{ asset('assets/js/city.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    @include('layouts.notification.success')
    <h2 class=" text-center mt-3">لیست درخواست ها</h2>
    <form method="get" class="mt-3">
        <div class="row">
            <div class="col-12 col-md-6 col-lg-2 form-group mt-3">
                <input type="text" class="form-control" name="mcode" id="mcode" placeholder="کد ملی" value="{{request('mcode')}}">
            </div>
            <div class="col-12 col-md-6 col-lg-2 form-group mt-3  ms-0 ms-lg-2">
                <input type="text" class="form-control ms-0 ms-md-2" name="phone" id="phone" placeholder="شماره موبایل" value="{{request('phone')}}">
            </div>
            <div class="col-12 col-md-6 col-lg-2 form-group mt-3 ms-0 ms-lg-2">
                <input type="text" class="form-control" name="fname" id="fname" placeholder="نام سرتیم" value="{{request('fname')}}">
            </div>
            <div class="col-12 col-md-6 col-lg-2 form-group mt-3 ms-0 ms-lg-2 ">
                <input type="text" class="form-control" name="lname" id="lname" placeholder="نام خانوادگی" value="{{request('lname')}}">
            </div>
            <div class="col-12 col-md-6 col-lg-3 form-group mt-3 mt-md-0 d-flex justify-content-between">
                <div class="form-group mt-3">
                    <button type="submit" class="btn btn-primary ms-0 ms-md-3">فیلتر</button>
                </div>

                @if(request('mcode') || request('phone') || request('fname') || request('lname'))
                <div class="form-group  mt-3">
                    <a href="{{ request()->url() }}" class="btn btn-outline-secondary ms-0 ms-md-2">حذف فیلتر</a>
                </div>
                @endif
            </div>

        </div>
    </form>
    <form action="{{route('distributor.printlist')}}" method="get">
        <input type="hidden" name="userId" value="{{auth()->user()->id}}">
        <button type="submit" class="btn btn-outline-success mt-3">دریافت خروجی از کارکرد</button>
    </form>
    @include('Distributor.list.table')
</div>
@endsection