@extends('layouts.index')
@section('css-part')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
<link rel="stylesheet" href="{{ asset('assets/css/jalalidatepicker.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/css/general.panel.css') }}">
<style>
    .step-table {
        border: 1px solid #000000;
        width: 100%;
    }

    .step-table th {
        padding: 5px 8px;
        background-color: #5560ad;
        border: 1px solid #000000;
        color: #ffffff;
        text-align: center;
        max-width: 50%;
    }

    .step-table td {
        padding: 5px 8px;
        border: 1px solid #000000;
        text-align: center;
    }
</style>
@endsection
@section('js-part')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{{ asset('assets/js/jalalidatepicker.min.js') }}"></script>
<script src="{{ asset('assets/js/general.panel.js') }}"></script>
<script>
    $(document).ready(function() {
        jalaliDatepicker.startWatch({
            minDate: "attr",
            maxDate: "attr",
            minTime: "attr",
            maxTime: "attr",
            time: false,
            date: true,
            hasSecond: true,
            hideAfterChange: false,
            autoHide: true,
            showTodayBtn: true,
            showEmptyBtn: true,
            topSpace: 10,
            bottomSpace: 30,
            overflowSpace: -10,
            dayRendering(opt, input) {
                return {
                    isHollyDay: opt.day == 1,
                };
            },
        });
    });
</script>
@endsection
@section('panel')
@include('layouts.header.header')
@include('layouts.nav.nav')
@endsection
@section('container')
<div class="container">
    @include('layouts.notification.success')
    <h2 class=" text-center mt-3">لیست کار های تمام شده</h2>
    <form action="" method="get" class="mt-3">
        <div class="row">
            <div class="col-12 col-lg-3">
                <label for="user" class="mb-2">نمایش برای</label>
                <select class=" form-control" name="user" id="user">
                    <option value="{{Auth::id()}}" {{(request('user') == Auth::id()) ? 'selected' : ''}}>خودم</option>
                    @foreach ($user_workers as $worker)
                    <option value="{{$worker->id}}" {{(request('user') == $worker->id) ? 'selected' : ''}}>{{$worker->first_name}} {{$worker->last_name}}</option> 
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-3 mt-3 mt-lg-0">
                <label for="from" class="mb-2">از تاریخ</label>
                <input type="text" name="from" id="from" class=" form-control" placeholder="از تاریخ" dir="ltr" data-jdp required value="{{request('from') ?? ''}}">
            </div>
            <div class="col-12 col-lg-3 mt-3 mt-lg-0">
                <label for="to" class="mb-2">به تاریخ</label>
                <input type="text" name="to" id="to" class=" form-control" placeholder="به تاریخ" dir="ltr" data-jdp required value="{{request('to') ?? ''}}">
            </div>
            <div class="col-12 col-lg-3 mt-3 mt-lg-0 d-flex align-items-end">
                <button type="submit" class=" btn btn-success">نمایش</button>
            </div>
        </div>
    </form>
    @if (!empty(request('from')) && !empty(request('to')))
    @include('chiefWorker.list.status')
    @endif

</div>
@endsection