<div class="zar-table mt-3">
    <table>
        <thead>
            <tr>
                <th>ردیف</th>
                <th>نوع درخواست</th>
                <th>وزن</th>
                <th>وضعیت</th>
                <th>تاریخ ثبت</th>
                <th>عملیات</th>
            </tr>
        </thead>
        <tbody>
            @if ($RequestInfo->isNotEmpty())
            @foreach ($RequestInfo as $Info)
            <tr>
                <td data-label="ردیف">{{ $loop->iteration }}</td>
                <td data-label="نوع درخواست">
                    @switch($Info->type)
                    @case(1)
                    تحویل گل
                    @break
                    @endswitch
                </td>
                <td data-label="وزن">
                    وزن گل: {{ $Info->weight['farmer'] }}
                  <!--  @if (isset($Info->weight['dryer']['کلاله']))
                        <br>
                        وزن کلاله تر: {{$Info->weight['dryer']['کلاله']}} گرم
                    @endif
                    @if (isset($Info->weight['dryer']['زعفران']))
                        <br>
                        وزن کلاله خشک: {{$Info->weight['dryer']['زعفران']}} گرم
                    @endif -->
                </td>
                <td data-label="وضعیت">
                    @switch($Info->step)
                    @case(1)
                    درخواست جدید
                    @break
                    @case(2)
                    در انتظار تایید قرارداد
                    @break
                    @case(3)
                    قرارداد تایید شد
                    @break
                    @case(4)
                    در انتظار تحویل
                    @break
                    @case(5)
                    @if (strstr($Info->step_info[count($Info->step_info) - 1]['action'],'مغایرت'))
                    در انتظار تایید مرکز فراوری
                    @else   
                    دریافت توسط راننده
                    @endif
                    @break
                    @case(6)
                    تحویل توسط مرکز فراوری
                    @break
                    @case(7)
                    @case(8)
                    در حال پاکسازی گل   
                    @break
                    @case(9)
                    اتمام پاکسازی
                    @break
                    @case(10)
                    ورود به واحد خشک کن
                    @break
                    @case(11)
                    اتمام خشک کردن    
                    @break
                    @case(12)
                    ورود به واحد بسته بندی      
                    @break
                    @case(13)
                    اتمام کار و ارسال         
                    @break
                    @endswitch
                </td>
                <td data-label="تاریخ ثبت">{{ jdate($Info->created_at)->format('Y/m/d') }}</td>
                <td data-label="عملیات">
                    @switch($Info->step)
                    @case(1)
                    @case(3)
                    در حال بررسی
                    @break
                    @case(2)
                        <a href="{{route('farmer.contract',['code' => $Info->token])}}" class="btn btn-primary">مطالعه و تایید قرارداد</a>
                    @break
                    @case(4)
                        @if (is_array($Info->transportation))
                            راننده برای تحویل تعیین شد
                            {{$Info->transportation['name']}}
                        @endif
                    @break
                    @case(5)
                    @case(6)
                    @case(7)
                    @case(8)
                    @case(9)
                    @case(10)
                    @case(11)
                    @case(12)
                        عملیاتی نیاز نیست
                    @break
                    @case(13)
                        اتمام سفارش
                    @break
                    @endswitch
                </td>
            </tr>
            @endforeach
            @else
            <tr>
                <td colspan="6" class="noinfotable">شما سفارشی ثبت نکرده اید</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>