@if (isset($NotifMessages) && $NotifMessages->isNotEmpty())
@php
$NotifText = '<div class="d-block">';
    foreach($NotifMessages as $MessageInfo)
    {
    $NotifText .= '<div style="border-bottom: 1px solid #000000; padding-bottom: 10px; margin-bottom: 10px; text-align: right;">
        <div><strong>'.jdate($MessageInfo->created_at)->format('Y/m/d').'</strong></div>
        <div>'.e($MessageInfo->message).'</div>
    </div>';
    }
    $NotifText .= "</div>";
@endphp
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    Swal.fire({
        title: 'توجه !',
        html: `{!! $NotifText !!}`,
        icon: 'info',
        confirmButtonText: 'متوجه شدم'
    }).then((result) => {
        if (result.isConfirmed) {

            fetch('{{ route("message.seen") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        id: {{ auth()->id() }}
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        console.log('Success');
                        
                    }
                });
        }
    });
</script>
@endif