<div class="mt-3">
    <strong class=" mt-3 mb-3">لیست سفارشات</strong>
    <div class="zar-table">
        <table>
            <thead>
                <tr>
                    <th>ردیف</th>
                    <th>نام کشاورز</th>
                    <th>نام مزرعه</th>
                    <th>کد سفارش</th>
                    <th>وزن گل</th>
                    <th>نوع درخواست</th>
                    <th>وضعیت</th>
                    <th>تاریخ ثبت</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
                <?php if($RequestInfo->isNotEmpty()): ?>
                <?php $__currentLoopData = $RequestInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if(strstr(json_encode($Info->step_info, JSON_UNESCAPED_UNICODE),'یادداشت توسط')): ?>
                        <td data-label="ردیف" style="color: red; font-weight: 700;"><?php echo e($loop->iteration + ((int) request('page') * 25)); ?></td>
                    <?php else: ?>
                        <td data-label="ردیف"><?php echo e($loop->iteration + ((int) request('page') * 25)); ?></td>
                    <?php endif; ?>
                    
                    <td data-label="نام کشاورز"><?php echo e($Info->first_name); ?> <?php echo e($Info->last_name); ?></td>
                    <td data-label="نام مزرعه"><?php echo e($Info->farm_name); ?></td>
                    <td data-label="کد سفارش"><?php echo e($Info->id); ?></td>
                    <td data-label="وزن گل"><?php echo e($Info->weight['farmer']); ?></td>
                    <td data-label="نوع درخواست">
                        <?php switch($Info->type):
                        case (1): ?>
                        تحویل گل
                        <?php break; ?>
                        <?php case (2): ?>
                        تحویل پیاز
                        <?php break; ?>
                        <?php endswitch; ?>
                    </td>
                    <td data-label="وضعیت">
                        <?php switch($Info->step):
                        case (1): ?>
                        درخواست جدید
                        <?php break; ?>
                        <?php case (2): ?>
                        در انتظار تایید کشاورز
                        <?php break; ?>
                        <?php case (3): ?>
                        قرارداد تایید شد
                        <?php break; ?>
                        <?php case (4): ?>
                        در انتظار تحویل
                        <?php break; ?>
                        <?php case (5): ?>
                        <?php if(strstr($Info->step_info[count($Info->step_info) - 1]['action'],'مغایرت')): ?>
                        در انتظار تایید مرکز فراوری
                        <?php else: ?>
                        دریافت توسط راننده
                        <?php endif; ?>
                        <?php break; ?>
                        <?php case (6): ?>
                        دریافت توسط مرکز فراوری
                        <?php break; ?>
                        <?php case (7): ?>
                        توزیع به سرتیم ها
                        <?php break; ?>
                        <?php case (8): ?>
                        اعلام اتمام کار توسط کارگران
                        <?php break; ?>
                        <?php case (9): ?>
                        اتمام کار توسط همه سرتیم ها
                        <?php break; ?>
                        <?php case (10): ?>
                        دریافت توسط مرکز خشک کن
                        <?php break; ?>
                        <?php case (11): ?>
                        اتمام خشک کردن
                        <?php break; ?>
                        <?php case (12): ?>
                        دریافت توسط واحد بسته بندی
                        <?php break; ?>
                        <?php case (13): ?>
                        اتمام سفارش و ارسال
                        <?php break; ?>
                        <?php default: ?>
                        <?php if($Info->step < 0 && $Info->step > -100): ?>
                            مغایرت
                            <?php elseif($Info->step < -100): ?>
                                لغو شده
                                <?php endif; ?>
                                <?php endswitch; ?>
                                </td>
                    <td data-label="تاریخ ثبت"><?php echo jdate($Info->created_at)->format('Y/m/d'); ?></td>
                    <td data-label="عملیات">
                        <a href="<?php echo e(route('admin.view',['id' => $Info->id])); ?>" class="btn btn-primary">جزئیات</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr>
                    <td colspan="7" class="noinfotable">درخواستی یافت نشد</td>
                </tr>
                <?php endif; ?>

            </tbody>
        </table>
    </div>
    <div class="mt-3">
        <?php echo e($RequestInfo->appends(request()->query())->links()); ?>

    </div>
</div><?php /**PATH /home1/zarborji/public_html/resources/views/Admin/list/requests.blade.php ENDPATH**/ ?>