<?php

namespace App\Http\Controllers\Distributor;

use App\Http\Controllers\Controller;
use App\Models\AppRequest;
use App\Models\WorkReq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali\Jalalian;

class UserController extends Controller
{
    public function show()
    {
        $perPage = 25;
        $page = request()->input('page', 1);

        $query = AppRequest::where('requests.step', 6)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name');

        $query->where(function ($q) {
            $q->whereNull('requests.step_info')
                ->orWhereJsonDoesntContain('requests.step_info', ['action' => 'بین سرتیم ها توزیع شد']);
        });

        $UserRequests = $query->orderBy('id', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);

        return view('Distributor.index', compact('UserRequests'));
    }

    public function viewEdit($id = null)
    {
        $RequestInfo = AppRequest::where('requests.id', $id)
            ->where('requests.step', 6)
            ->join('users', 'requests.user_id', '=', 'users.id')
            ->join('farmer_profiles', 'requests.user_id', '=', 'farmer_profiles.user_id')
            ->select('requests.*', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'farmer_profiles.state', 'farmer_profiles.city', 'farmer_profiles.address', 'farmer_profiles.farm_name', 'farmer_profiles.father_name')
            ->first();

        $UserRequests = WorkReq::where('user_requests.request_id', $id)
            ->join('users', 'users.id', 'user_requests.user_id')
            ->where('users.role', 'chief_worker')
            ->select('user_requests.info', 'users.first_name', 'users.last_name', 'users.phone', 'users.melli_code', 'users.role', 'users.id')
            ->get();

        if ($RequestInfo !== null) {
            return view('Distributor.edit', compact(['RequestInfo', 'UserRequests']));
        }
        return redirect()->route('distributor.panel');
    }

    public function accept(Request $request)
    {
        $requestId = $request->input('requestId');

        if (isset($requestId) && ctype_digit($requestId) && $requestId > 0) {
            $RequestInfo = AppRequest::where('requests.id',$requestId)->first();

            if ($RequestInfo !== null) {
                $stepInfo = $RequestInfo->step_info;

                if (!is_array($stepInfo)) {
                    $stepInfo = [];
                }

                $stepInfo[] = [
                    'action' => 'توزیع کننده: ' . Auth::user()->first_name . ' ' . Auth::user()->last_name,
                    'user_id' => Auth::id(),
                    'date' => Jalalian::now()->format('Y/m/d H:i:s')
                ];

                $stepInfo[] = [
                    'action' => 'بین سرتیم ها توزیع شد',
                    'user_id' => Auth::id(),
                    'date' => Jalalian::now()->format('Y/m/d H:i:s')
                ];

                $RequestInfo->step_info =  $stepInfo;

                $RequestInfo->save();
                return redirect()->route('distributor.panel')->with('success', 'توزیع شما با موفقیت ثبت شد!');
            }
        }

        return redirect()->route('distributor.panel')->with('error', 'مشکلی در ثبت وضعیت توزیع رخ داد!');
    }
}
