<?php

namespace App\Http\Requests;

use App\Rules\IranianPhone;
use App\Rules\Nationalcode;
use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'melli_code' => ['required', new Nationalcode, 'unique:users,melli_code'],
            'phone' => ['required', new IranianPhone, 'unique:users,phone'],
            'father_name' => 'required',
            'farm_name' => 'required',
            'state' => 'required|not_in:0',
            'city' => 'required|not_in:0',
            'address' => 'required'
        ];
    }

    public function messages()
    {
        return [
            'mell_code.required' => 'کد ملی وارد نشده است.',
            'farm_name.required' => 'نام مزرعه وارد نشده است',
            'phone.required' => 'شماره موبایل وارد نشده است',
            'father_name.required' => 'نام پدر وارد نشده است',
            'address.required' => 'آدرس وارد نشده است',
            'city.not_in' => 'شهر انتخاب نشده است',
            'state.not_in' => 'استان انتخاب نشده است',
            'mell_code.unique' => 'کدملی قبلا ثبت شده است',
            'phone.unique' => 'شماره موبایل قبلا ثبت شده است'
            
        ];
    }
}
